/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.plugins;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.text.StringEscapeUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.ZipEntryBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;

public class Zip2HtmlConverter
implements Converter {
    protected static final String INDEX_HTML = "index.html";

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        Blob zipBlob = blobHolder.getBlob();
        String mimeType = zipBlob.getMimeType();
        if (!mimeType.equals("application/zip") && !mimeType.equals("application/x-zip-compressed")) {
            throw new ConversionException("not a zip file", blobHolder);
        }
        ArrayList<String> names = new ArrayList<String>();
        Optional<Blob> indexBlob = this.listNamesAndCreateIndex(zipBlob, names);
        ArrayList blobs = new ArrayList();
        indexBlob.ifPresent(blobs::add);
        names.forEach(name -> blobs.add(new ZipEntryBlob(zipBlob, name)));
        return new SimpleBlobHolder(blobs);
    }

    protected Optional<Blob> listNamesAndCreateIndex(Blob zipBlob, List<String> names) {
        block17: {
            File file = zipBlob.getFile();
            if (file != null) {
                try (ZipFile zipFile = new ZipFile(file);){
                    zipFile.stream().forEach(entry -> names.add(entry.getName()));
                    break block17;
                }
                catch (IOException e) {
                    throw new NuxeoException((Throwable)e);
                }
            }
            try (ZipInputStream zin = new ZipInputStream(new BufferedInputStream(zipBlob.getStream()));){
                ZipEntry entry2;
                while ((entry2 = zin.getNextEntry()) != null) {
                    names.add(entry2.getName());
                }
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
        this.orderIndexFirst(names);
        if (names.isEmpty() || names.get(0).contains(INDEX_HTML)) {
            return Optional.empty();
        }
        Blob indexBlob = this.createIndexBlob(zipBlob.getFilename(), names);
        return Optional.of(indexBlob);
    }

    protected void orderIndexFirst(List<String> names) {
        String indexName = null;
        for (String name : names) {
            if (!name.contains(INDEX_HTML) || indexName != null && name.compareTo(indexName) >= 0) continue;
            indexName = name;
        }
        if (indexName != null) {
            names.remove(indexName);
            names.add(0, indexName);
        }
    }

    protected Blob createIndexBlob(String title, List<String> names) {
        StringBuilder page = new StringBuilder("<html><body>");
        page.append("<h1>").append(StringEscapeUtils.escapeEcmaScript((String)StringEscapeUtils.escapeHtml4((String)title))).append("</h1>");
        page.append("<ul>");
        for (String name : names) {
            String fn = StringEscapeUtils.escapeEcmaScript((String)StringEscapeUtils.escapeHtml4((String)name));
            page.append("<li><a href=\"").append(fn).append("\">");
            page.append(fn);
            page.append("</a></li>");
        }
        page.append("</ul></body></html>");
        return Blobs.createBlob((String)page.toString(), (String)"text/html", null, (String)INDEX_HTML);
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

