/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.ecm.platform.relations.api.DocumentRelationManager;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.GraphDescription;
import org.nuxeo.ecm.platform.relations.api.GraphFactory;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.ResourceAdapter;
import org.nuxeo.ecm.platform.relations.descriptors.GraphTypeDescriptor;
import org.nuxeo.ecm.platform.relations.services.DocumentRelationService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class RelationService
extends DefaultComponent
implements RelationManager {
    private static final Logger log = LogManager.getLogger(RelationService.class);
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.relations.services.RelationService");
    protected static final String TYPES_EP = "graphtypes";
    protected static final String GRAPHS_EP = "graphs";
    protected static final String ADAPTERS_EP = "resourceadapters";
    protected static final Collector<GraphDescription, ?, Map<String, GraphDescription>> COLLECTOR_TO_NAME_DESC_MAP = Collectors.toMap(GraphDescription::getName, Function.identity());
    protected Map<String, Class<?>> graphTypes;
    protected Map<String, GraphDescription> graphDescriptions;
    protected Map<String, GraphFactory> graphFactories;
    protected Map<String, Graph> graphRegistry;

    public void start(ComponentContext context) {
        this.graphTypes = new HashMap();
        this.graphDescriptions = this.getRegistryContributions(GRAPHS_EP).stream().collect(COLLECTOR_TO_NAME_DESC_MAP);
        this.getRegistryContributions(TYPES_EP).forEach(this::registerGraphType);
        this.graphRegistry = new Hashtable<String, Graph>();
        this.graphFactories = new Hashtable<String, GraphFactory>();
        this.initGraphs();
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.graphTypes = null;
        this.graphDescriptions = null;
        this.graphRegistry = null;
        this.graphFactories = null;
    }

    protected void initGraphs() {
        RepositoryService repositoryService = (RepositoryService)Framework.getService(RepositoryService.class);
        if (repositoryService == null) {
            return;
        }
        log.info("Relation Service initialization");
        for (GraphDescription desc : this.graphDescriptions.values()) {
            String graphName = desc.getName();
            log.info("Create Graph {}", (Object)graphName);
            if (desc.getGraphType().equalsIgnoreCase("jena")) {
                TransactionHelper.runWithoutTransaction(() -> {
                    Graph graph = this.getGraphByName(graphName);
                    graph.size();
                });
                continue;
            }
            TransactionHelper.runInTransaction(() -> {
                Graph graph = this.getGraphByName(graphName);
                graph.size();
            });
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(RelationManager.class)) {
            return (T)((Object)this);
        }
        if (adapter.isAssignableFrom(DocumentRelationManager.class)) {
            return (T)new DocumentRelationService();
        }
        return null;
    }

    private void registerGraphType(GraphTypeDescriptor graphTypeDescriptor) {
        Class<?> klass;
        String graphType = graphTypeDescriptor.getName();
        String className = graphTypeDescriptor.getClassName();
        try {
            klass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Cannot register unknown class for graph type %s: %s", graphType, className), e);
        }
        if (!Graph.class.isAssignableFrom(klass) && !GraphFactory.class.isAssignableFrom(klass)) {
            throw new RuntimeException("Invalid graph class/factory type: " + className);
        }
        this.graphTypes.put(graphType, klass);
        log.info(String.format("Registered graph type: %s (%s)", graphType, className));
    }

    public List<String> getGraphTypes() {
        return new ArrayList<String>(this.graphTypes.keySet());
    }

    private ResourceAdapter getResourceAdapterForNamespace(String namespace) {
        return this.getRegistryContribution(ADAPTERS_EP, namespace).map(desc -> {
            try {
                ResourceAdapter adapter = desc.getAdapterClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                adapter.setNamespace(namespace);
                return adapter;
            }
            catch (ReflectiveOperationException e) {
                log.error("Cannot instantiate generator with namespace '%s': %s", (Object)namespace, (Object)e);
                return null;
            }
        }).orElse(null);
    }

    public Graph getGraphByName(String name) {
        return this.getGraph(name, null);
    }

    public Graph getGraph(String name, CoreSession session) {
        GraphDescription graphDescription = this.graphDescriptions.get(name);
        if (graphDescription == null) {
            throw new RuntimeException("No such graph: " + name);
        }
        Graph graph = this.getGraphFromRegistries(graphDescription, session);
        if (graph != null) {
            return graph;
        }
        Class<?> klass = this.graphTypes.get(graphDescription.getGraphType());
        if (Graph.class.isAssignableFrom(klass)) {
            try {
                graph = (Graph)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            this.graphRegistry.put(name, graph);
        } else {
            GraphFactory factory;
            try {
                factory = (GraphFactory)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            this.graphFactories.put(name, factory);
        }
        return this.getGraphFromRegistries(graphDescription, session);
    }

    protected Graph getGraphFromRegistries(GraphDescription graphDescription, CoreSession session) {
        String name = graphDescription.getName();
        Graph graph = this.graphRegistry.get(name);
        if (graph != null) {
            graph.setDescription(graphDescription);
            return graph;
        }
        GraphFactory factory = this.graphFactories.get(name);
        if (factory != null) {
            return factory.createGraph(graphDescription, session);
        }
        return null;
    }

    protected Graph newGraph(String className) {
        try {
            Class<?> klass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
            return (Graph)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public Graph getTransientGraph(String type) {
        Class<?> klass = this.graphTypes.get(type);
        if (Graph.class.isAssignableFrom(klass)) {
            try {
                return (Graph)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Graph type cannot be transient: " + type);
    }

    public Resource getResource(String namespace, Serializable object, Map<String, Object> context) {
        ResourceAdapter adapter = this.getResourceAdapterForNamespace(namespace);
        if (adapter == null) {
            return null;
        }
        return adapter.getResource(object, context);
    }

    public Set<Resource> getAllResources(Serializable object, Map<String, Object> context) {
        HashSet<Resource> res = new HashSet<Resource>();
        Set namespaces = ((MapRegistry)this.getExtensionPointRegistry(ADAPTERS_EP)).getContributions().keySet();
        for (String ns : namespaces) {
            Class klass;
            ResourceAdapter adapter = this.getResourceAdapterForNamespace(ns);
            if (adapter == null || (klass = adapter.getKlass()) == null || !klass.isAssignableFrom(object.getClass())) continue;
            res.add(adapter.getResource(object, context));
        }
        return res;
    }

    public Serializable getResourceRepresentation(String namespace, Resource resource, Map<String, Object> context) {
        ResourceAdapter adapter = this.getResourceAdapterForNamespace(namespace);
        if (adapter == null) {
            return null;
        }
        return adapter.getResourceRepresentation(resource, context);
    }

    public List<String> getGraphNames() {
        return new ArrayList<String>(this.graphDescriptions.keySet());
    }
}

