/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.io;

import java.io.IOException;
import java.io.Reader;
import org.openjena.atlas.io.CharStreamReader;
import org.openjena.atlas.io.IO;

public final class CharStreamBuffered
extends CharStreamReader {
    static final int CB_SIZE = 131072;
    private final char[] chars;
    private int buffLen = 0;
    private int idx = 0;
    private final Source source;

    public CharStreamBuffered(Reader r) {
        this(r, 131072);
    }

    public CharStreamBuffered(Reader r, int buffSize) {
        this.source = new SourceReader(r);
        this.chars = new char[buffSize];
    }

    public final int advance() {
        if (this.idx >= this.buffLen) {
            this.fillArray();
        }
        if (this.buffLen >= 0) {
            char ch = this.chars[this.idx];
            ++this.idx;
            return ch;
        }
        return -1;
    }

    private int fillArray() {
        int x = this.source.fill(this.chars);
        this.idx = 0;
        this.buffLen = x;
        return x;
    }

    public void closeStream() {
        this.source.close();
    }

    static final class SourceReader
    implements Source {
        final Reader reader;

        SourceReader(Reader r) {
            this.reader = r;
        }

        public void close() {
            try {
                this.reader.close();
            }
            catch (IOException ex) {
                IO.exception(ex);
            }
        }

        public int fill(char[] array) {
            try {
                return this.reader.read(array);
            }
            catch (IOException ex) {
                IO.exception(ex);
                return -1;
            }
        }
    }

    private static interface Source {
        public int fill(char[] var1);

        public void close();
    }
}

