/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.context;

import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.automation.context.ContextHelper;
import org.nuxeo.ecm.automation.context.ContextHelperDescriptor;
import org.w3c.dom.Element;

public class ContextHelperRegistry
extends MapRegistry {
    private static final Logger log = LogManager.getLogger(ContextHelperRegistry.class);
    protected static final List<String> RESERVED_VAR_NAMES = List.of("CurrentDate", "Context", "ctx", "This", "Session", "CurrentUser", "currentUser", "Env", "Document", "currentDocument", "Documents", "params", "input");
    protected static final Collector<ContextHelperDescriptor, ?, Map<String, ContextHelper>> COLLECTOR = Collectors.toMap(ContextHelperDescriptor::getId, ContextHelperDescriptor::getContextHelper);

    protected <T> T doRegister(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
        Object contrib;
        String id = this.computeId(ctx, xObject, element);
        if (this.shouldRemove(ctx, xObject, element, extensionId)) {
            this.contributions.remove(id);
            return null;
        }
        if (RESERVED_VAR_NAMES.contains(id)) {
            log.error("The context helper with id '{}' cannot be registered: this identifier is reserved. Please use another one (reserved identifiers: {})", (Object)id, RESERVED_VAR_NAMES);
            return null;
        }
        Object existing = this.contributions.get(id);
        if (this.shouldMerge(ctx, xObject, element, extensionId, id, existing)) {
            contrib = this.getMergedInstance(ctx, xObject, element, existing);
            if (existing != null) {
                log.warn("The context helper id/alias '{}' is overridden by the following helper: {}", (Object)id, contrib);
            }
        } else {
            contrib = this.getInstance(ctx, xObject, element);
        }
        this.contributions.put(id, contrib);
        Boolean enable = this.shouldEnable(ctx, xObject, element, extensionId);
        if (enable != null) {
            if (Boolean.TRUE.equals(enable)) {
                this.disabled.remove(id);
            } else {
                this.disabled.add(id);
            }
        }
        return (T)contrib;
    }

    public Map<String, ContextHelper> getContextHelpers() {
        return this.getContributionValues().stream().collect(COLLECTOR);
    }
}

