/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core;

import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.AutomationAdmin;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.context.ContextHelperRegistry;
import org.nuxeo.ecm.automation.context.ContextService;
import org.nuxeo.ecm.automation.context.ContextServiceImpl;
import org.nuxeo.ecm.automation.core.events.EventHandlerRegistry;
import org.nuxeo.ecm.automation.core.exception.ChainExceptionRegistry;
import org.nuxeo.ecm.automation.core.impl.AutomationFilterRegistry;
import org.nuxeo.ecm.automation.core.impl.ChainRegistry;
import org.nuxeo.ecm.automation.core.impl.OperationRegistry;
import org.nuxeo.ecm.automation.core.impl.OperationServiceImpl;
import org.nuxeo.ecm.automation.core.impl.TypeAdapterRegistry;
import org.nuxeo.ecm.automation.core.trace.TracerFactory;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.ServerLocator;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class AutomationComponent
extends DefaultComponent {
    private static final Logger log = LogManager.getLogger(AutomationComponent.class);
    public static final String COMPONENT_NAME = "org.nuxeo.ecm.automation.core.AutomationComponent";
    public static final String XP_OPERATIONS = "operations";
    public static final String XP_ADAPTERS = "adapters";
    public static final String XP_CHAINS = "chains";
    public static final String XP_EVENT_HANDLERS = "event-handlers";
    public static final String XP_CHAIN_EXCEPTION = "chainException";
    public static final String XP_AUTOMATION_FILTER = "automationFilter";
    public static final String XP_CONTEXT_HELPER = "contextHelpers";
    protected OperationServiceImpl service;
    protected ContextService contextService;
    protected TracerFactory tracerFactory;

    protected void bindManagement() throws JMException {
        ObjectName objectName = new ObjectName("org.nuxeo.automation:name=tracerfactory");
        MBeanServer mBeanServer = ((ServerLocator)Framework.getService(ServerLocator.class)).lookupServer();
        mBeanServer.registerMBean(this.tracerFactory, objectName);
    }

    protected void unBindManagement() throws MalformedObjectNameException, MBeanRegistrationException, InstanceNotFoundException {
        ObjectName on = new ObjectName("org.nuxeo.automation:name=tracerfactory");
        ServerLocator locator = (ServerLocator)Framework.getService(ServerLocator.class);
        if (locator != null) {
            MBeanServer mBeanServer = locator.lookupServer();
            mBeanServer.unregisterMBean(on);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == AutomationService.class || adapter == AutomationAdmin.class) {
            return adapter.cast(this.service);
        }
        if (adapter == EventHandlerRegistry.class) {
            return adapter.cast(this.getExtensionPointRegistry(XP_EVENT_HANDLERS));
        }
        if (adapter == TracerFactory.class) {
            return adapter.cast(this.tracerFactory);
        }
        if (adapter == ContextService.class) {
            return adapter.cast(this.contextService);
        }
        return null;
    }

    public void start(ComponentContext context) {
        this.service = new OperationServiceImpl((OperationRegistry)this.getExtensionPointRegistry(XP_OPERATIONS), (ChainRegistry)this.getExtensionPointRegistry(XP_CHAINS), (ChainExceptionRegistry)this.getExtensionPointRegistry(XP_CHAIN_EXCEPTION), (AutomationFilterRegistry)this.getExtensionPointRegistry(XP_AUTOMATION_FILTER), (TypeAdapterRegistry)this.getExtensionPointRegistry(XP_ADAPTERS));
        this.checkOperationChains();
        this.contextService = new ContextServiceImpl((ContextHelperRegistry)this.getExtensionPointRegistry(XP_CONTEXT_HELPER));
        this.tracerFactory = new TracerFactory();
        if (!this.tracerFactory.getRecordingState()) {
            log.info("You can activate automation trace mode to get more informations on automation executions");
        }
        try {
            this.bindManagement();
        }
        catch (JMException e) {
            throw new RuntimeException("Cannot bind management", e);
        }
    }

    protected void checkOperationChains() {
        List<OperationChain> chains = this.service.getOperationChains();
        for (OperationChain chain : chains) {
            List<OperationParameters> opps = chain.getOperations();
            for (OperationParameters opp : opps) {
                if (this.service.hasOperation(opp.id())) continue;
                String msg = String.format("Operation chain with id '%s' references unknown operation with id '%s'", chain.getId(), opp.id());
                log.error(msg);
                this.addRuntimeMessage(RuntimeMessage.Level.ERROR, msg);
            }
        }
    }

    public void stop(ComponentContext context) {
        this.service.flushCompiledChains();
        this.service = null;
        this.contextService = null;
        try {
            this.unBindManagement();
        }
        catch (JMException e) {
            throw new RuntimeException("Cannot unbind management", e);
        }
        this.tracerFactory = null;
    }
}

