/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.core.impl.adapters.helper.TypeAdapterHelper;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.impl.DocumentRefListImpl;
import org.nuxeo.ecm.core.schema.utils.DateParser;

@XObject(value="chain")
@XRegistry(merge=false, enable=false, remove=false)
public class OperationChainContribution {
    @XNode(value="@id")
    @XRegistryId
    protected String id;
    @XNode(value="@replace", defaultAssignment="true")
    protected boolean replace = true;
    @XNode(value="description")
    protected String description;
    @XNodeList(value="operation", type=Operation[].class, componentType=Operation.class)
    protected Operation[] ops = new Operation[0];
    @XNode(value="public")
    protected boolean isPublic = true;
    @XNodeList(value="param", type=OperationDocumentation.Param[].class, componentType=OperationDocumentation.Param.class)
    protected OperationDocumentation.Param[] params = new OperationDocumentation.Param[0];
    @XNodeList(value="aliases/alias", type=String[].class, componentType=String.class)
    protected String[] aliases;

    public OperationDocumentation.Param[] getParams() {
        return this.params;
    }

    public String getId() {
        return this.id;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public OperationChain toOperationChain(Context ctx) throws OperationException {
        OperationChain chain = new OperationChain(this.id);
        chain.setDescription(this.description);
        chain.setPublic(this.isPublic);
        chain.setAliases(this.aliases);
        for (Operation op : this.ops) {
            OperationParameters params = chain.add(op.id);
            for (Param param : op.params) {
                param.value = param.value.trim();
                param.value = StringEscapeUtils.unescapeXml((String)param.value);
                if (param.value.startsWith("expr:")) {
                    String value = param.value.substring(5);
                    if (value.contains("@{")) {
                        params.set(param.name, Scripting.newTemplate(value));
                        continue;
                    }
                    params.set(param.name, Scripting.newExpression(value));
                    continue;
                }
                Object val = null;
                String type = param.type.toLowerCase();
                char c = type.charAt(0);
                switch (c) {
                    case 's': {
                        if (!"string".equals(type)) break;
                        val = param.value;
                        break;
                    }
                    case 'p': {
                        if (!"properties".equals(type)) break;
                        if (param.map != null && !param.map.isEmpty()) {
                            val = new Properties(param.map);
                            break;
                        }
                        try {
                            val = new Properties(param.value);
                            break;
                        }
                        catch (IOException e) {
                            throw new OperationException(e);
                        }
                    }
                    case 'i': {
                        if (!"integer".equals(type)) break;
                        val = Integer.valueOf(param.value);
                        break;
                    }
                    case 'l': {
                        if (!"long".equals(type)) break;
                        val = Long.valueOf(param.value);
                        break;
                    }
                    case 'b': {
                        if (!"boolean".equals(type)) break;
                        val = Boolean.valueOf(param.value);
                        break;
                    }
                    case 'd': {
                        if ("document".equals(type)) {
                            val = TypeAdapterHelper.createDocumentRefOrExpression(param.value);
                            break;
                        }
                        if ("documents".equals(type)) {
                            String[] ar = StringUtils.split((String)param.value, (char)',', (boolean)true);
                            DocumentRefListImpl result = new DocumentRefListImpl(ar.length);
                            for (String ref : ar) {
                                result.add((Object)TypeAdapterHelper.createDocumentRef(ref));
                            }
                            val = result;
                            break;
                        }
                        if (!"date".equals(type)) break;
                        val = DateParser.parseW3CDateTime((String)param.value);
                        break;
                    }
                    case 'f': {
                        if (!"float".equals(type)) break;
                        val = Double.valueOf(param.value);
                        break;
                    }
                    case 'r': {
                        if (!"resource".equals(type)) break;
                        if (param.value.contains(":/")) {
                            try {
                                val = new URL(param.value);
                                break;
                            }
                            catch (MalformedURLException e) {
                                throw new OperationException(e);
                            }
                        }
                        val = ctx.getResource(param.value);
                    }
                }
                if (val == null) {
                    val = param.value;
                }
                params.set(param.name, val);
            }
        }
        return chain;
    }

    public Operation[] getOps() {
        return this.ops;
    }

    public String getLabel() {
        return this.id;
    }

    public String getRequires() {
        return "";
    }

    public String getCategory() {
        return "Chain";
    }

    public String getSince() {
        return "";
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public static OperationChainContribution contribOf(OperationChain chain, boolean replace) {
        OperationChainContribution contrib = new OperationChainContribution();
        contrib.id = chain.getId();
        contrib.aliases = chain.getAliases();
        contrib.description = "inlined chain of " + contrib.id;
        contrib.isPublic = false;
        contrib.params = OperationChainContribution.paramsOf(chain.getChainParameters());
        contrib.ops = OperationChainContribution.operationsOf(chain.getOperations());
        contrib.replace = replace;
        return contrib;
    }

    public static OperationDocumentation.Param[] paramsOf(Map<String, ?> args) {
        return (OperationDocumentation.Param[])args.entrySet().stream().map(entry -> {
            OperationDocumentation.Param param = new OperationDocumentation.Param();
            param.name = (String)entry.getKey();
            param.type = entry.getClass().getName();
            return param;
        }).toArray(OperationDocumentation.Param[]::new);
    }

    public static Operation[] operationsOf(List<OperationParameters> operations) {
        return (Operation[])operations.stream().map(params -> {
            Operation op = new Operation();
            op.id = params.id();
            params.map().forEach((k, v) -> {
                Param param = new Param();
                param.name = k;
                param.type = "unknown";
                param.value = v == null ? "null" : v.toString();
                op.params.add(param);
            });
            return op;
        }).toArray(Operation[]::new);
    }

    @XObject(value="param")
    public static class Param {
        @XNode(value="@name")
        protected String name;
        @XNode(value="@type")
        protected String type = "string";
        @XContent
        protected String value;
        @XNodeMap(value="property", key="@key", type=HashMap.class, componentType=String.class, nullByDefault=true)
        protected Map<String, String> map;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getType() {
            return this.type;
        }

        public Map<String, String> getMap() {
            return this.map;
        }
    }

    @XObject(value="operation")
    public static class Operation {
        @XNode(value="@id")
        protected String id;
        @XNodeList(value="param", type=ArrayList.class, componentType=Param.class)
        protected List<Param> params = new ArrayList<Param>();

        public String getId() {
            return this.id;
        }

        public List<Param> getParams() {
            return this.params;
        }
    }
}

