/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.OperationContribution;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.impl.OperationRegistryContribution;
import org.nuxeo.ecm.automation.core.impl.OperationTypeImpl;
import org.nuxeo.ecm.platform.forms.layout.descriptors.WidgetDescriptor;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.api.Framework;
import org.w3c.dom.Element;

public class OperationRegistry
extends MapRegistry {
    private static final Logger log = LogManager.getLogger(OperationRegistry.class);

    public void register(OperationRegistryContribution registryContrib, String tag) {
        this.tag(tag);
        this.registrations.add(registryContrib);
        this.setInitialized(false);
    }

    public void initialize() {
        this.registrations.forEach(rc -> {
            if (rc instanceof OperationRegistryContribution) {
                this.doRegisterInstance((OperationRegistryContribution)((Object)rc));
            } else {
                this.doRegister(rc.getContext(), rc.getObject(), rc.getElement(), rc.getRuntimeExtensionFromTag());
            }
        });
        this.setInitialized(true);
    }

    protected void checkReplace(String id, boolean replace) {
        if (!replace && this.contributions.containsKey(id)) {
            throw new RuntimeServiceException("An operation is already bound to id '" + id + "': use 'replace=\"true\"' to replace an existing operation");
        }
    }

    protected void doRegisterInstance(OperationRegistryContribution rc) {
        String id = rc.getId();
        this.checkReplace(id, rc.isReplace());
        Object contrib = rc.getInstance();
        this.contributions.put(id, contrib);
        String[] aliases = rc.getAliases();
        this.doRegisterAliases(id, contrib, aliases);
    }

    protected <T> T doRegister(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
        OperationContribution opc = (OperationContribution)this.getInstance(ctx, xObject, element);
        try {
            Class<?> type = Class.forName(opc.type);
            List widgets = null;
            if (opc.widgets != null) {
                widgets = opc.widgets.stream().map(WidgetDescriptor::getWidgetDefinition).collect(Collectors.toList());
            }
            OperationTypeImpl contrib = new OperationTypeImpl(type, OperationRegistry.getContributingComponentId(extensionId), widgets);
            String id = contrib.getId();
            this.checkReplace(id, opc.replace);
            this.contributions.put(id, contrib);
            this.doRegisterAliases(id, contrib, contrib.getAliases());
            return (T)contrib;
        }
        catch (ClassNotFoundException | IllegalArgumentException | RuntimeServiceException e) {
            String msg = String.format("Failed to register operation in component '%s' with class '%s' (%s)", extensionId, opc.type, e.toString());
            Framework.getRuntime().getMessageHandler().addMessage(new RuntimeMessage(RuntimeMessage.Level.ERROR, msg, RuntimeMessage.Source.EXTENSION, extensionId));
            return null;
        }
    }

    protected void doRegisterAliases(String id, Object contrib, String[] aliases) {
        for (String alias : aliases) {
            if (id.equals(alias)) {
                log.warn("Useless alias for operation with id '{}'", (Object)id);
                continue;
            }
            if (this.contributions.containsKey(alias)) {
                log.warn("Overriding operation with id '{}' with alias from operation '{}'", (Object)alias, (Object)id);
            }
            this.contributions.put(alias, contrib);
        }
    }

    public static final String getContributingComponentId(String tagOrExtensionId) {
        return StringUtils.substringBeforeLast((String)tagOrExtensionId, (String)"#");
    }

    public OperationType getOperationType(Class<?> key) {
        return (OperationType)this.contributions.get(key.getAnnotation(Operation.class).id());
    }
}

