/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationAdmin;
import org.nuxeo.ecm.automation.AutomationFilter;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.ChainException;
import org.nuxeo.ecm.automation.CompiledChain;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.TypeAdapter;
import org.nuxeo.ecm.automation.core.exception.CatchChainException;
import org.nuxeo.ecm.automation.core.exception.ChainExceptionRegistry;
import org.nuxeo.ecm.automation.core.impl.AutomationFilterRegistry;
import org.nuxeo.ecm.automation.core.impl.ChainRegistry;
import org.nuxeo.ecm.automation.core.impl.ChainTypeImpl;
import org.nuxeo.ecm.automation.core.impl.OperationChainCompiler;
import org.nuxeo.ecm.automation.core.impl.OperationRegistry;
import org.nuxeo.ecm.automation.core.impl.TypeAdapterRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class OperationServiceImpl
implements AutomationService,
AutomationAdmin {
    private static final Log log = LogFactory.getLog(OperationServiceImpl.class);
    public static final String EXPORT_ALIASES_CONFIGURATION_PARAM = "nuxeo.automation.export.aliases";
    protected final OperationRegistry operations;
    protected final ChainRegistry chains;
    protected final ChainExceptionRegistry chainExceptions;
    protected final AutomationFilterRegistry filters;
    protected final TypeAdapterRegistry adapters;
    protected final OperationChainCompiler compiler = new OperationChainCompiler(this);

    public OperationServiceImpl(OperationRegistry operations, ChainRegistry chains, ChainExceptionRegistry chainExceptions, AutomationFilterRegistry filters, TypeAdapterRegistry adapters) {
        this.operations = operations;
        this.chains = chains;
        this.chainExceptions = chainExceptions;
        this.filters = filters;
        this.adapters = adapters;
    }

    @Override
    public Object run(OperationContext ctx, String operationId) throws OperationException {
        return this.run(ctx, this.getOperationChain(operationId));
    }

    @Override
    public Object run(OperationContext ctx, String operationId, Map<String, ?> args) throws OperationException {
        OperationChain chain = this.getOperationChain(operationId);
        if (args == null) {
            log.warn((Object)("Null operation parameters given for " + operationId), new Throwable("stack trace"));
            args = Collections.emptyMap();
        }
        return ctx.callWithChainParameters(() -> this.run(ctx, chain), args);
    }

    @Override
    public Object run(OperationContext ctx, OperationChain chain) throws OperationException {
        Object input = ctx.getInput();
        Class<Void> inputType = input == null ? Void.TYPE : input.getClass();
        CompiledChain compiled = this.compileChain(inputType, chain);
        boolean completedAbruptly = true;
        try {
            Object result = compiled.invoke(ctx);
            completedAbruptly = false;
            Object object = result;
            return object;
        }
        catch (OperationException cause) {
            completedAbruptly = false;
            if (this.hasChainException(chain.getId())) {
                Object object = this.run(ctx, this.getChainExceptionToRun(ctx, chain.getId(), cause));
                return object;
            }
            throw cause;
        }
        finally {
            if (completedAbruptly) {
                ctx.setRollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object runInNewTx(OperationContext ctx, String chainId, Map<String, ?> chainParameters, Integer timeout, boolean rollbackGlobalOnError) throws OperationException {
        Object result = null;
        if (TransactionHelper.isTransactionMarkedRollback()) {
            return null;
        }
        TransactionHelper.commitOrRollbackTransaction();
        int to = timeout == null ? 0 : timeout;
        TransactionHelper.startTransaction((int)to);
        boolean ok = false;
        try {
            result = this.run(ctx, chainId, chainParameters);
            ok = true;
        }
        catch (OperationException e) {
            if (rollbackGlobalOnError) {
                throw e;
            }
            log.error((Object)("Error while executing operation " + chainId), (Throwable)e);
        }
        finally {
            if (!ok) {
                TransactionHelper.setTransactionRollbackOnly();
            }
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
        return result;
    }

    protected String getChainExceptionToRun(OperationContext ctx, String operationTypeId, OperationException oe) throws OperationException {
        ctx.put("Exception", (Object)oe.getClass().getSimpleName());
        ctx.put("exceptionName", (Object)oe.getClass().getSimpleName());
        ctx.put("exceptionObject", (Object)oe);
        ChainException chainException = this.getChainException(operationTypeId);
        CatchChainException catchChainException = new CatchChainException();
        for (CatchChainException catchChainExceptionItem : chainException.getCatchChainExceptions()) {
            if (Boolean.TRUE.equals(catchChainExceptionItem.hasFilter())) {
                AutomationFilter filter = this.getAutomationFilter(catchChainExceptionItem.getFilterId());
                try {
                    String filterValue = (String)filter.getValue().eval(ctx);
                    if (!Boolean.parseBoolean(filterValue)) continue;
                    catchChainException = this.getCatchChainExceptionByPriority(catchChainException, catchChainExceptionItem);
                    continue;
                }
                catch (RuntimeException e) {
                    throw new OperationException("Cannot evaluate Automation Filter " + filter.getId() + " mvel expression.", e);
                }
            }
            catchChainException = this.getCatchChainExceptionByPriority(catchChainException, catchChainExceptionItem);
        }
        String chainId = catchChainException.getChainId();
        if (chainId.isEmpty()) {
            throw new OperationException("No chain exception has been selected to be run. You should verify Automation filters applied.");
        }
        if (Boolean.TRUE.equals(catchChainException.getRollBack())) {
            ctx.setRollback();
        }
        return catchChainException.getChainId();
    }

    protected CatchChainException getCatchChainExceptionByPriority(CatchChainException catchChainException, CatchChainException catchChainExceptionItem) {
        return catchChainException.getPriority() <= catchChainExceptionItem.getPriority() ? catchChainExceptionItem : catchChainException;
    }

    public static OperationParameters[] toParams(String ... ids) {
        OperationParameters[] operationParameters = new OperationParameters[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            operationParameters[i] = new OperationParameters(ids[i]);
        }
        return operationParameters;
    }

    @Override
    public OperationChain getOperationChain(String id) throws OperationNotFoundException {
        OperationType type = this.getOperation(id);
        if (type instanceof ChainTypeImpl) {
            return ((ChainTypeImpl)type).chain;
        }
        OperationChain chain = new OperationChain(id);
        chain.add(id);
        return chain;
    }

    @Override
    public List<OperationChain> getOperationChains() {
        ArrayList<ChainTypeImpl> chainsType = new ArrayList<ChainTypeImpl>();
        ArrayList<OperationChain> chains = new ArrayList<OperationChain>();
        for (OperationType operationType : this.getOperations()) {
            if (!(operationType instanceof ChainTypeImpl)) continue;
            chainsType.add((ChainTypeImpl)operationType);
        }
        for (ChainTypeImpl chainType : chainsType) {
            chains.add(chainType.getChain());
        }
        return chains;
    }

    @Override
    public synchronized void flushCompiledChains() {
        this.compiler.cache.invalidateAll();
    }

    @Override
    public OperationType[] getOperations() {
        List values = this.operations.getContributionValues();
        return values.toArray(new OperationType[values.size()]);
    }

    @Override
    public OperationType getOperation(String id) throws OperationNotFoundException {
        return (OperationType)this.operations.getContribution(id).orElseThrow(() -> new OperationNotFoundException("No operation was bound on ID: " + id));
    }

    @Override
    public boolean hasOperation(String id) {
        return this.operations.getContribution(id).isPresent();
    }

    @Override
    public CompiledChain compileChain(Class<?> inputType, OperationParameters ... ops) throws OperationException {
        return this.compileChain(inputType, new OperationChain("", Arrays.asList(ops)));
    }

    @Override
    public CompiledChain compileChain(Class<?> inputType, OperationChain chain) throws OperationException {
        return this.compiler.compile(ChainTypeImpl.typeof(chain, false), inputType);
    }

    @Override
    public TypeAdapter getTypeAdapter(Class<?> accept, Class<?> produce) {
        return this.adapters.getTypeAdapter(accept, produce);
    }

    @Override
    public boolean isTypeAdaptable(Class<?> typeToAdapt, Class<?> targetType) {
        return this.getTypeAdapter(typeToAdapt, targetType) != null;
    }

    @Override
    public <T> T getAdaptedValue(OperationContext ctx, Object toAdapt, Class<?> targetType) throws OperationException {
        Class toAdaptClass;
        if (targetType.isAssignableFrom(Void.class)) {
            return null;
        }
        if (OperationContext.class.isAssignableFrom(targetType)) {
            return (T)ctx;
        }
        Class clazz = toAdaptClass = toAdapt == null ? Void.class : toAdapt.getClass();
        if (targetType.isPrimitive() && (targetType = OperationServiceImpl.getTypeForPrimitive(targetType)).isAssignableFrom(toAdaptClass)) {
            return (T)toAdapt;
        }
        if (targetType.isArray() && toAdapt instanceof List) {
            Iterable iterable = (Iterable)toAdapt;
            return (T)Iterables.toArray((Iterable)iterable, targetType.getComponentType());
        }
        TypeAdapter adapter = this.getTypeAdapter(toAdaptClass, targetType);
        if (adapter == null) {
            if (toAdapt == null) {
                return null;
            }
            if (toAdapt instanceof JsonNode) {
                ObjectMapper mapper = new ObjectMapper();
                return (T)mapper.convertValue(toAdapt, targetType);
            }
            if (targetType.isAssignableFrom(OperationContext.class)) {
                return (T)ctx;
            }
            throw new OperationException("No type adapter found for input: " + toAdaptClass + " and output " + targetType);
        }
        return (T)adapter.getAdaptedValue(ctx, toAdapt);
    }

    @Override
    public List<OperationDocumentation> getDocumentation() throws OperationException {
        ArrayList<OperationDocumentation> result = new ArrayList<OperationDocumentation>();
        OperationType[] ops = this.getOperations();
        ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        boolean exportAliases = configurationService.isBooleanTrue(EXPORT_ALIASES_CONFIGURATION_PARAM);
        for (OperationType ot : ops) {
            try {
                OperationDocumentation documentation = ot.getDocumentation();
                result.add(documentation);
                String[] aliases = ot.getAliases();
                if (!exportAliases || aliases == null || aliases.length <= 0) continue;
                for (String alias : aliases) {
                    result.add(OperationDocumentation.copyForAlias(documentation, alias));
                }
            }
            catch (OperationNotFoundException operationNotFoundException) {
                // empty catch block
            }
        }
        Collections.sort(result);
        return result;
    }

    public static Class<?> getTypeForPrimitive(Class<?> primitiveType) {
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        return primitiveType;
    }

    @Override
    public ChainException[] getChainExceptions() {
        return (ChainException[])this.chainExceptions.getContributionValues().toArray(ChainException[]::new);
    }

    @Override
    public ChainException getChainException(String onChainId) {
        return this.chainExceptions.getChainException(onChainId).orElse(null);
    }

    @Override
    public boolean hasChainException(String onChainId) {
        return this.chainExceptions.getChainException(onChainId).isPresent();
    }

    @Override
    public AutomationFilter getAutomationFilter(String id) {
        return this.filters.getAutomationFilter(id);
    }

    @Override
    public AutomationFilter[] getAutomationFilters() {
        return (AutomationFilter[])this.filters.getContributionValues().toArray(AutomationFilter[]::new);
    }
}

