/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.core.utils.BlobUtils;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Blob.BulkDownload", category="Files", label="Bulk Download", description="Prepare a Zip of a list of documents.")
public class BulkDownload {
    public static final String ID = "Blob.BulkDownload";
    protected static final String DOWNLOAD_REASON = "download";
    private static final Logger log = LogManager.getLogger(BulkDownload.class);
    @Context
    protected CoreSession session;
    @Param(name="filename", required=false)
    protected String fileName;

    @OperationMethod
    public Blob run(DocumentModelList docs) throws IOException {
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        List blobs = docs.stream().map(doc -> {
            Blob blob = downloadService.resolveBlob(doc);
            if (blob == null) {
                log.trace("Not able to resolve blob");
                return null;
            }
            if (!downloadService.checkPermission(doc, null, blob, DOWNLOAD_REASON, Collections.emptyMap())) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((DocumentModel)doc).getPathAsString();
                log.debug("Not allowed to bulk download blob for document {}", supplierArray);
                return null;
            }
            downloadService.logDownload(null, doc, null, blob.getFilename(), DOWNLOAD_REASON, null);
            return blob;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (blobs.isEmpty()) {
            log.debug("No blob to be zipped");
            return null;
        }
        String filename = StringUtils.isNotBlank((CharSequence)this.fileName) ? this.fileName : String.format("BlobListZip-%s-%s", UUID.randomUUID(), this.session.getPrincipal().getName());
        return BlobUtils.zip(blobs, (String)filename);
    }
}

