/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.query.sql.NXQL;

@Operation(id="Document.FetchByProperty", category="Fetch", label="Fetch By Property", description="For each specified string property value, fetch all documents that match the property and the optional where clause. Matching documents are collected into a list and the returned to the next operation. The operation has no input.")
public class FetchByProperty {
    public static final String ID = "Document.FetchByProperty";
    @Context
    protected CoreSession session;
    @Param(name="property", required=true)
    protected String property;
    @Param(name="values", required=true)
    protected StringList values;
    @Param(name="query", required=false)
    protected String query;

    @OperationMethod
    public DocumentModelList run() {
        if (this.values.isEmpty()) {
            return new DocumentModelListImpl();
        }
        if (StringUtils.isBlank((CharSequence)this.query)) {
            this.query = null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM Document WHERE ");
        sb.append(this.property);
        if (this.values.size() == 1) {
            sb.append(" = ");
            sb.append(NXQL.escapeString((String)((String)this.values.get(0))));
        } else {
            sb.append(" IN (");
            Iterator it = this.values.iterator();
            while (it.hasNext()) {
                sb.append(NXQL.escapeString((String)((String)it.next())));
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        if (this.query != null) {
            sb.append(" AND (");
            sb.append(this.query);
            sb.append(")");
        }
        String q = sb.toString();
        return this.session.query(q);
    }
}

