/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.trace;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.Constants;
import org.nuxeo.ecm.automation.core.trace.Call;
import org.nuxeo.ecm.automation.core.trace.TracerFactory;

public class Trace {
    private static final Log log = LogFactory.getLog(TracerFactory.class);
    protected final Call parent;
    protected final OperationType chain;
    protected final List<Call> calls;
    protected final Object input;
    protected final Object output;
    protected final Exception error;

    protected Trace(Call parent, OperationType chain, List<Call> calls, Object input, Object output, Exception error) {
        this.parent = parent;
        this.chain = chain;
        this.calls = new ArrayList<Call>(calls);
        this.input = input;
        this.output = output;
        this.error = error;
    }

    public Call getParent() {
        return this.parent;
    }

    public OperationType getChain() {
        return this.chain;
    }

    public Exception getError() {
        return this.error;
    }

    public Object getInput() {
        return this.input;
    }

    public Object getOutput() {
        return this.output;
    }

    public List<Call> getCalls() {
        return this.calls;
    }

    public String toString() {
        return this.print(true);
    }

    protected void printHeading(String heading, BufferedWriter writer) throws IOException {
        writer.append(Constants.LF).append(Constants.LF).append("****** ").append(heading).append(" ******");
    }

    protected void litePrint(BufferedWriter writer) throws IOException {
        this.printHeading("chain", writer);
        writer.append(Constants.LF);
        if (this.getParent() != null) {
            writer.append("Parent Chain ID: ");
            writer.append(this.getParent().getChainId());
            writer.append(Constants.LF);
        }
        writer.append("Name: ");
        writer.append(this.getChain().getId());
        if (this.getChain().getAliases() != null && this.getChain().getAliases().length > 0) {
            writer.append(Constants.LF);
            writer.append("Aliases: ");
            writer.append(Arrays.toString(this.getChain().getAliases()));
        }
        if (this.error != null) {
            writer.append(Constants.LF);
            writer.append("Exception: ");
            writer.append(this.error.getClass().getSimpleName());
            writer.append(Constants.LF);
            writer.append("Caught error: ");
            writer.append(this.error.getMessage());
            writer.append(Constants.LF);
            writer.append("Caused by: ");
            writer.append(this.error.toString());
        }
        writer.append(Constants.LF);
        writer.append("****** Hierarchy calls ******");
        this.litePrintCall(this.calls, writer);
        writer.flush();
    }

    protected void litePrintCall(List<Call> calls, BufferedWriter writer) throws IOException {
        writer.append(Constants.LF);
        try {
            this.printCalls(calls, writer);
            for (Call call : calls) {
                if (call.getNested().isEmpty()) continue;
                writer.append(Constants.LF);
                this.printHeading("start sub chain", writer);
                for (Trace trace : call.getNested()) {
                    trace.litePrint(writer);
                }
                writer.append(Constants.LF);
                this.printHeading("end sub chain", writer);
            }
        }
        catch (IOException e) {
            log.error((Object)"Nuxeo TracePrinter cannot write traces output", (Throwable)e);
        }
    }

    protected void print(BufferedWriter writer) throws IOException {
        this.printHeading("chain", writer);
        if (this.error != null) {
            writer.append(Constants.LF);
            if (this.getParent() != null) {
                writer.append("Parent Chain ID: ");
                writer.append(this.getParent().getChainId());
                writer.append(Constants.LF);
            }
            writer.append("Name: ");
            writer.append(this.getChain().getId());
            if (this.getChain().getAliases() != null && this.getChain().getAliases().length > 0) {
                writer.append(Constants.LF);
                writer.append("Aliases: ");
                writer.append(Arrays.toString(this.getChain().getAliases()));
            }
            writer.append(Constants.LF);
            writer.append("Exception: ");
            writer.append(this.error.getClass().getSimpleName());
            writer.append(Constants.LF);
            writer.append("Caught error: ");
            writer.append(this.error.getMessage());
            writer.append(Constants.LF);
            writer.append("Caused by: ");
            writer.append(this.error.toString());
        } else {
            writer.append(Constants.LF);
            if (this.getParent() != null) {
                writer.append("Parent Chain ID: ");
                writer.append(this.getParent().getChainId());
                writer.append(Constants.LF);
            }
            writer.append("Name: ");
            writer.append(this.getChain().getId());
            writer.append(Constants.LF);
            writer.append("Produced output type: ");
            writer.append(this.output == null ? "Void" : this.output.getClass().getSimpleName());
        }
        writer.append(Constants.LF);
        writer.append("****** Hierarchy calls ******");
        writer.append(Constants.LF);
        this.printCalls(this.calls, writer);
        writer.flush();
    }

    protected void printCalls(List<Call> calls, BufferedWriter writer) throws IOException {
        Object tabs = "\t";
        for (Call call : calls) {
            writer.append((CharSequence)tabs);
            call.print(writer);
            tabs = (String)tabs + "\t";
        }
    }

    public String print(boolean litePrint) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        try {
            if (litePrint) {
                this.litePrint(writer);
            } else {
                this.print(writer);
            }
        }
        catch (IOException cause) {
            return "Cannot print automation trace of " + this.chain.getId();
        }
        return new String(out.toByteArray(), Charset.forName("UTF-8"));
    }
}

