/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management;

import org.nuxeo.ecm.core.event.EventStats;
import org.nuxeo.ecm.core.management.api.AdministrativeStatusManager;
import org.nuxeo.ecm.core.management.api.GlobalAdministrativeStatusManager;
import org.nuxeo.ecm.core.management.api.ProbeManager;
import org.nuxeo.ecm.core.management.events.EventStatsHolder;
import org.nuxeo.ecm.core.management.events.EventStatsImpl;
import org.nuxeo.ecm.core.management.probes.ProbeManagerImpl;
import org.nuxeo.ecm.core.management.statuses.AdministrativeStatusManagerImpl;
import org.nuxeo.ecm.core.management.statuses.GlobalAdministrativeStatusManagerImpl;
import org.nuxeo.ecm.core.management.storage.DocumentStoreManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class CoreManagementComponent
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName(CoreManagementComponent.class.getCanonicalName());
    public static final String PROBES_EP = "probes";
    public static final String SERVICE_DEF_EP = "serviceDefinition";
    public static final String STORAGE_HANDLERS_EP = "storageHandlers";
    public static final String STORAGE_CONFIG_EP = "storageConfiguration";
    public static final String HEALTH_CHECK_EP = "healthCheck";
    protected final EventStats eventStats = new EventStatsImpl();
    protected GlobalAdministrativeStatusManager globalManager;
    protected ProbeManagerImpl probeRunner;
    protected DocumentStoreManager storageManager;

    public void activate(ComponentContext context) {
        EventStatsHolder.clearStats();
    }

    public void deactivate(ComponentContext context) {
        EventStatsHolder.clearStats();
    }

    public void start(ComponentContext context) {
        this.globalManager = new GlobalAdministrativeStatusManagerImpl();
        this.getRegistryContributions(SERVICE_DEF_EP).forEach(this.globalManager::registerService);
        this.probeRunner = new ProbeManagerImpl();
        this.getRegistryContributions(PROBES_EP).forEach(this.probeRunner::registerProbe);
        this.getRegistryContributions(HEALTH_CHECK_EP).forEach(this.probeRunner::registerProbeForHealthCheck);
        this.storageManager = new DocumentStoreManager();
        this.storageManager.install();
        this.getRegistryContributions(STORAGE_HANDLERS_EP).forEach(this.storageManager::registerHandler);
        this.getRegistryContribution(STORAGE_CONFIG_EP).ifPresent(this.storageManager::registerConfig);
    }

    protected AdministrativeStatusManagerImpl getLocalManager() {
        return (AdministrativeStatusManagerImpl)this.globalManager.getStatusManager(this.globalManager.getLocalNuxeoInstanceIdentifier());
    }

    public void onNuxeoServerStartup() {
        this.getLocalManager().onNuxeoServerStartup();
    }

    public void stop(ComponentContext context) {
        this.getLocalManager().onNuxeoServerShutdown();
        this.globalManager = null;
        this.probeRunner = null;
        this.storageManager.uninstall();
        this.storageManager = null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == EventStats.class) {
            return adapter.cast(this.eventStats);
        }
        if (adapter.isAssignableFrom(GlobalAdministrativeStatusManager.class)) {
            return adapter.cast(this.globalManager);
        }
        if (adapter.isAssignableFrom(AdministrativeStatusManager.class)) {
            return adapter.cast(this.getLocalManager());
        }
        if (adapter.isAssignableFrom(ProbeManager.class)) {
            return adapter.cast(this.probeRunner);
        }
        return (T)super.getAdapter(adapter);
    }

    @Deprecated
    public static CoreManagementComponent getDefault() {
        return (CoreManagementComponent)((Object)Framework.getService(CoreManagementComponent.class));
    }
}

