/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.statuses;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.management.api.ProbeInfo;

public class HealthCheckResult {
    private static final Logger log = LogManager.getLogger(HealthCheckResult.class);
    protected static final String EMPTY_JSON = "{}";
    protected final Collection<ProbeInfo> probes;
    protected final boolean healthy;

    public HealthCheckResult(Collection<ProbeInfo> probesToCheck) {
        this.probes = probesToCheck;
        this.healthy = this.probes.stream().allMatch(p -> p.getStatus().isSuccess());
        if (!this.healthy) {
            log.warn("HealthCheck is not healthy, see probes: {}", this.probes);
        }
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    public String toJson() {
        ObjectMapper om = new ObjectMapper();
        HashMap<String, String> res = new HashMap<String, String>();
        try {
            for (ProbeInfo probe : this.probes) {
                res.put(probe.getShortcutName(), probe.getStatus().isSuccess() ? "ok" : "failed");
            }
            return om.writeValueAsString(res);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to write HealthCheckResult to json", (Throwable)e);
            return EMPTY_JSON;
        }
    }
}

