/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.statuses;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.management.api.ProbeManager;
import org.nuxeo.ecm.core.management.statuses.HealthCheckResult;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;

public class StatusServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(StatusServlet.class);
    public static final String PARAM = "info";
    public static final String PARAM_STARTED = "started";
    public static final String PARAM_SUMMARY = "summary";
    public static final String PARAM_SUMMARY_KEY = "key";
    public static final String PARAM_RELOAD = "reload";
    public static final String PROBE_PARAM = "probe";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String param = req.getParameter(PARAM);
        if (param != null) {
            this.doPost(req, resp);
        } else {
            HealthCheckResult result = this.getOrRunHealthCheck(null);
            this.sendHealthCheckResponse(resp, result);
        }
    }

    protected void sendHealthCheckResponse(HttpServletResponse resp, HealthCheckResult result) throws IOException {
        if (result.isHealthy()) {
            resp.setStatus(200);
        } else {
            resp.setStatus(500);
        }
        this.sendResponse(resp, result.toJson());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        StringBuilder response = new StringBuilder();
        String requestedInfo = req.getParameter(PARAM);
        if (requestedInfo.equals(PARAM_STARTED)) {
            this.getStartedInfo(response);
        } else if (requestedInfo.equals(PARAM_SUMMARY)) {
            String givenKey = req.getParameter(PARAM_SUMMARY_KEY);
            if (Framework.getRuntime().getProperty("server.status.key").equals(givenKey)) {
                this.getSummaryInfo(response);
            } else {
                resp.setStatus(403);
            }
        } else if (requestedInfo.equals(PARAM_RELOAD)) {
            if (this.isStarted()) {
                response.append("reload();");
            } else {
                resp.setStatus(503);
            }
        } else if (requestedInfo.equals(PROBE_PARAM)) {
            String probetoEval = req.getParameter(PARAM_SUMMARY_KEY);
            try {
                HealthCheckResult result = this.getOrRunHealthCheck(probetoEval);
                this.sendHealthCheckResponse(resp, result);
            }
            catch (IllegalArgumentException e) {
                resp.setStatus(404);
            }
        }
        this.sendResponse(resp, response.toString());
    }

    protected void sendResponse(HttpServletResponse resp, String response) throws IOException {
        resp.setContentType("application/json");
        resp.setContentLength(response.getBytes().length);
        ServletOutputStream out = resp.getOutputStream();
        out.write(response.getBytes());
        out.close();
    }

    protected void getSummaryInfo(StringBuilder response) {
        if (this.isStarted()) {
            StringBuilder msg = new StringBuilder();
            boolean isFine = Framework.getRuntime().getStatusMessage(msg);
            response.append(isFine).append("\n");
            response.append((CharSequence)msg);
        } else {
            response.append(false).append("\n");
            response.append("Runtime failed to start");
        }
    }

    protected void getStartedInfo(StringBuilder response) {
        response.append(this.isStarted()).toString();
    }

    private boolean isStarted() {
        RuntimeService runtimeService = Framework.getRuntime();
        return runtimeService != null && runtimeService.isStarted();
    }

    public void init() throws ServletException {
        log.debug((Object)"Ready.");
    }

    protected HealthCheckResult getOrRunHealthCheck(String probe) {
        ProbeManager pm = (ProbeManager)Framework.getService(ProbeManager.class);
        if (StringUtils.isEmpty((CharSequence)probe)) {
            return pm.getOrRunHealthChecks();
        }
        return pm.getOrRunHealthCheck(probe);
    }
}

