/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.storage;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.management.CoreManagementComponent;
import org.nuxeo.ecm.core.management.storage.DocumentStoreConfigurationDescriptor;
import org.nuxeo.ecm.core.management.storage.DocumentStoreHandler;
import org.nuxeo.ecm.core.management.storage.DocumentStoreHandlerDescriptor;
import org.nuxeo.ecm.core.management.storage.DocumentStoreSessionRunner;
import org.nuxeo.ecm.core.repository.RepositoryInitializationHandler;
import org.nuxeo.runtime.api.Framework;

public class DocumentStoreManager
extends RepositoryInitializationHandler {
    public static final String MANAGEMENT_ROOT_TYPE = "ManagementRoot";
    public static final String MANAGEMENT_ROOT_NAME = "management";
    public static final String MANAGEMENT_ROOT_PATH = "/management";
    protected final List<DocumentStoreHandler> handlers = new ArrayList<DocumentStoreHandler>();
    protected DocumentStoreConfigurationDescriptor config = new DocumentStoreConfigurationDescriptor();
    protected String defaultRepositoryName;
    protected boolean mgmtInitialized;
    protected boolean defaultInitialized;
    protected DocumentRef rootletRef;

    public static PathRef newPath(String ... components) {
        StringBuilder sb = new StringBuilder();
        sb.append(MANAGEMENT_ROOT_PATH);
        for (String component : components) {
            sb.append("/").append(component);
        }
        return new PathRef(sb.toString());
    }

    public void registerHandler(DocumentStoreHandlerDescriptor desc) {
        try {
            this.handlers.add(desc.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Cannot instantiate " + desc.clazz, e);
        }
    }

    public void registerConfig(DocumentStoreConfigurationDescriptor config) {
        this.config = config;
        DocumentStoreSessionRunner.repositoryName = config.repositoryName;
    }

    public void doInitializeRepository(CoreSession session) {
        String repositoryName;
        if (this.defaultRepositoryName == null) {
            RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
            this.defaultRepositoryName = mgr.getDefaultRepositoryName();
            if (DocumentStoreSessionRunner.repositoryName == null) {
                DocumentStoreSessionRunner.repositoryName = this.defaultRepositoryName;
            }
        }
        if ((repositoryName = session.getRepositoryName()).equals(DocumentStoreSessionRunner.repositoryName)) {
            this.mgmtInitialized = true;
            this.rootletRef = this.setupRootlet(session);
            for (DocumentStoreHandler handler : this.handlers) {
                handler.onStorageInitialization(session, this.rootletRef);
            }
        }
        if (repositoryName.equals(this.defaultRepositoryName)) {
            this.defaultInitialized = true;
        }
        if (this.defaultInitialized && this.mgmtInitialized) {
            ((CoreManagementComponent)((Object)Framework.getService(CoreManagementComponent.class))).onNuxeoServerStartup();
        }
    }

    protected DocumentModel createRootlet(CoreSession session) {
        DocumentModel rootlet = session.createDocumentModel("/", MANAGEMENT_ROOT_NAME, MANAGEMENT_ROOT_TYPE);
        rootlet = session.createDocument(rootlet);
        ACP acp = rootlet.getACP();
        ACL acl = acp.getOrCreateACL();
        for (ACE ace : acl.getACEs()) {
            acl.remove((Object)ace);
        }
        acl.add(new ACE(this.config.groupName, "Everything", true));
        acl.add(new ACE("Everyone", "Everything", false));
        rootlet.setACP(acp, true);
        session.save();
        return rootlet;
    }

    protected DocumentRef setupRootlet(CoreSession session) {
        DocumentModel rootlet = !session.exists((DocumentRef)new PathRef(MANAGEMENT_ROOT_PATH)) ? this.createRootlet(session) : session.getDocument((DocumentRef)new PathRef(MANAGEMENT_ROOT_PATH));
        return rootlet.getRef();
    }
}

