/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.service;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.SingleRegistry;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginProviderLink;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginScreenConfig;
import org.w3c.dom.Element;

public class LoginScreenConfigRegistry
extends SingleRegistry {
    protected Map<String, LoginProviderLink> programmaticLinks = Collections.synchronizedMap(new LinkedHashMap());

    public void initialize() {
        super.initialize();
        this.getContribution().ifPresent(conf -> this.programmaticLinks.values().forEach(l -> conf.merge(new LoginScreenConfig((LoginProviderLink)l))));
    }

    protected <T> T getMergedInstance(Context ctx, XAnnotatedObject xObject, Element element, Object existing) {
        LoginScreenConfig contrib = (LoginScreenConfig)this.getInstance(ctx, xObject, element);
        if (existing != null) {
            ((LoginScreenConfig)existing).merge(contrib);
            return (T)existing;
        }
        return (T)contrib;
    }

    public void addContribution(LoginScreenConfig config) {
        List<LoginProviderLink> links = config.getProviders();
        if (!links.isEmpty()) {
            links.forEach(link -> this.programmaticLinks.put(link.getName(), (LoginProviderLink)link));
            this.initialize();
        }
    }

    public void removeContribution(LoginScreenConfig config) {
        List<LoginProviderLink> links = config.getProviders();
        if (!links.isEmpty()) {
            links.stream().map(LoginProviderLink::getName).forEach(this.programmaticLinks::remove);
            this.initialize();
        }
    }
}

