/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.exceptionhandling.service;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.DefaultNuxeoExceptionHandler;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.NuxeoExceptionHandler;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.NuxeoExceptionHandlerParameters;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.service.ExceptionHandlingService;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.service.RequestDumper;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class ExceptionHandlingComponent
extends DefaultComponent
implements ExceptionHandlingService {
    protected static final NuxeoExceptionHandler DEFAULT_EXCEPTION_HANDLER = new DefaultNuxeoExceptionHandler();
    protected NuxeoExceptionHandler exceptionHandler = DEFAULT_EXCEPTION_HANDLER;

    public void start(ComponentContext context) {
        this.getRegistryContribution(ExtensionPoint.exceptionhandler.name()).ifPresentOrElse(desc -> {
            this.exceptionHandler = this.newInstance(desc.getKlass());
        }, () -> {
            this.exceptionHandler = new DefaultNuxeoExceptionHandler();
        });
        NuxeoExceptionHandlerParameters parameters = new NuxeoExceptionHandlerParameters();
        this.getRegistryContribution(ExtensionPoint.errorhandlers.name()).ifPresent(desc -> {
            parameters.setBundleName(desc.getBundle());
            parameters.setHandlers(desc.getMessages());
            parameters.setLoggerName(desc.getLoggerName());
            parameters.setDefaultErrorPage(desc.getDefaultPage());
        });
        this.getRegistryContribution(ExtensionPoint.requestdump.name()).ifPresent(desc -> {
            RequestDumper dumper = this.newInstance(desc.getKlass());
            dumper.setNotListedAttributes(desc.getAttributes());
            parameters.setRequestDumper(dumper);
        });
        this.getRegistryContribution(ExtensionPoint.listener.name()).ifPresent(desc -> parameters.setListener(this.newInstance(desc.getKlass())));
        this.exceptionHandler.setParameters(parameters);
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.exceptionHandler = DEFAULT_EXCEPTION_HANDLER;
    }

    protected <T> T newInstance(Class<T> klass) {
        try {
            return klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void forwardToErrorPage(HttpServletRequest request, HttpServletResponse response, Throwable t) throws IOException, ServletException {
        this.exceptionHandler.handleException(request, response, t);
    }

    @Override
    public NuxeoExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public static enum ExtensionPoint {
        exceptionhandler,
        errorhandlers,
        requestdump,
        listener;

    }
}

