/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.idempotency;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.nuxeo.ecm.platform.web.common.idempotency.CopyingServletOutputStream;

public class CopyingResponseWrapper
extends HttpServletResponseWrapper
implements AutoCloseable {
    protected ServletOutputStream output;
    protected PrintWriter writer;
    protected final DeferredFileOutputStream copy;

    public CopyingResponseWrapper(int threshold, HttpServletResponse response) {
        super(response);
        this.copy = new DeferredFileOutputStream(threshold, response.getBufferSize(), "nxidem", null, null);
    }

    protected CopyingServletOutputStream getCopyingOutputStream() throws IOException {
        return new CopyingServletOutputStream(this.getResponse().getOutputStream(), this.copy);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called on this response.");
        }
        if (this.output == null) {
            this.output = this.getCopyingOutputStream();
        }
        return this.output;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.output != null) {
            throw new IllegalStateException("getOutputStream() has already been called on this response.");
        }
        if (this.writer == null) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.getCopyingOutputStream()), this.getCharacterEncoding()));
        }
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        super.flushBuffer();
        if (this.writer != null) {
            this.writer.flush();
        } else if (this.output != null) {
            this.output.flush();
        }
    }

    @Override
    public void close() throws IOException {
        File file;
        if (this.writer != null) {
            this.writer.close();
        } else if (this.output != null) {
            this.output.close();
        }
        if (!this.copy.isInMemory() && (file = this.copy.getFile()) != null) {
            Files.delete(file.toPath());
        }
    }

    public long getCopySize() {
        return this.copy.getByteCount();
    }

    public byte[] getCopyAsBytes() throws IOException {
        if (this.copy.isInMemory()) {
            return this.copy.getData();
        }
        this.copy.flush();
        return FileUtils.readFileToByteArray((File)this.copy.getFile());
    }
}

