/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.idempotency;

import java.io.IOException;
import java.time.Duration;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.platform.web.common.idempotency.CopyingResponseWrapper;
import org.nuxeo.ecm.platform.web.common.idempotency.NuxeoIdempotentResponse;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class NuxeoIdempotentFilter
extends HttpFilter {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(NuxeoIdempotentFilter.class);
    public static final String HEADER_KEY = "Idempotency-Key";
    public static final String STORE_PROPERTY = "org.nuxeo.request.idempotency.keyvaluestore.name";
    public static final String DEFAULT_STORE = "idempotentrequest";
    protected static final Duration DEFAULT_TTL = Duration.ofDays(1L);
    public static final String TTL_DURATION_PROPERTY = "org.nuxeo.request.idempotency.ttl.duration";
    public static final String INPROGRESS_MARKER = "{\"inprogress\":true}";
    public static final String INFO_SUFFIX = "_info";
    protected static final int DEFERRED_OUTPUT_STREAM_THRESHOLD = 0x100000;
    protected static final int MAX_CONTENT_SIZE = 0x500000;
    protected static final Set<String> IDEMPOTENT_METHODS = Set.of("GET", "HEAD", "OPTIONS", "TRACE", "PUT", "DELETE");

    protected Duration getTTL() {
        ConfigurationService cs = (ConfigurationService)Framework.getService(ConfigurationService.class);
        if (cs != null) {
            return cs.getDuration(TTL_DURATION_PROPERTY, DEFAULT_TTL);
        }
        return DEFAULT_TTL;
    }

    protected String getStoreName() {
        ConfigurationService cs = (ConfigurationService)Framework.getService(ConfigurationService.class);
        if (cs != null) {
            return cs.getString(STORE_PROPERTY, DEFAULT_STORE);
        }
        return DEFAULT_STORE;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.doFilterIdempotent(request, response, chain)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected boolean doFilterIdempotent(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String method = request.getMethod();
        if (IDEMPOTENT_METHODS.contains(method)) {
            log.debug("No idempotent processing done: method is already idempotent: {}", (Object)method);
            return false;
        }
        String key = request.getHeader(HEADER_KEY);
        if (key == null) {
            log.debug("No idempotent processing done: no {} header present", (Object)HEADER_KEY);
            return false;
        }
        log.debug("Idempotent request key: {}", (Object)key);
        KeyValueService kvs = (KeyValueService)Framework.getService(KeyValueService.class);
        if (kvs == null) {
            log.debug("KeyValueService not present");
            return false;
        }
        KeyValueStore store = kvs.getKeyValueStore(this.getStoreName());
        String storeStatus = store.getString(key + INFO_SUFFIX);
        byte[] storeContent = store.get(key);
        if (storeStatus == null) {
            log.debug("Handle new request for key: {}", (Object)key);
            long ttl = this.getTTL().toSeconds();
            store.put(key + INFO_SUFFIX, INPROGRESS_MARKER, ttl);
            try {
                CopyingResponseWrapper wrapper;
                block21: {
                    boolean bl;
                    wrapper = new CopyingResponseWrapper(0x100000, response);
                    try {
                        wrapper.setHeader(HEADER_KEY, key);
                        chain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
                        wrapper.flushBuffer();
                        long size = wrapper.getCopySize();
                        if (size <= 0x500000L) break block21;
                        log.debug("Not storing response for key: {} (status: {}, size in bytes: {}), max content size exceeded: {}", (Object)key, (Object)wrapper.getStatus(), (Object)size, (Object)0x500000);
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                wrapper.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException | ServletException e) {
                            if (!response.isCommitted()) {
                                response.setStatus(500);
                                response.setHeader(HEADER_KEY, key);
                            }
                            throw e;
                        }
                    }
                    wrapper.close();
                    return bl;
                }
                byte[] content = wrapper.getCopyAsBytes();
                store.put(key, content, ttl);
                store.put(key + INFO_SUFFIX, NuxeoIdempotentResponse.save((HttpServletResponse)wrapper), ttl);
                log.debug("Stored response for key: {} (status: {}, size in bytes: {})", (Object)key, (Object)wrapper.getStatus(), (Object)content.length);
                boolean bl = true;
                wrapper.close();
                return bl;
            }
            finally {
                if (response.getStatus() >= 400) {
                    store.put(key, (String)null);
                    store.put(key + INFO_SUFFIX, (String)null);
                    log.debug("Cleanup store: error for key: {}", (Object)key);
                }
            }
        }
        if (INPROGRESS_MARKER.equals(storeStatus)) {
            response.setStatus(409);
            response.setHeader(HEADER_KEY, key);
            log.debug("Conflict response for key: {}", (Object)key);
            return true;
        }
        try {
            NuxeoIdempotentResponse.restore(response, storeStatus.getBytes());
            response.setHeader(HEADER_KEY, key);
            response.getOutputStream().write(storeContent);
            log.debug("Returning stored response for key: {} (status: {}, size in bytes: {})", (Object)key, (Object)response.getStatus(), (Object)storeContent.length);
            return true;
        }
        catch (IOException e) {
            log.error("Error processing stored result for key: {}", (Object)key, (Object)e);
            return false;
        }
    }
}

