/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.requestcontroller.service;

import com.thetransactioncompany.cors.CORSFilter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.FilterConfigDescriptor;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.LRUCachingMap;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.NuxeoCorsFilterDescriptor;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.NuxeoHeaderDescriptor;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.RequestControllerManager;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.RequestFilterConfig;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.RequestFilterConfigImpl;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class RequestControllerService
extends DefaultComponent
implements RequestControllerManager {
    public static final String FILTER_CONFIG_EP = "filterConfig";
    public static final String CORS_CONFIG_EP = "corsConfig";
    public static final String HEADERS_CONFIG_EP = "responseHeaders";
    protected Map<String, FilterConfigDescriptor> grantPatterns;
    protected Map<String, FilterConfigDescriptor> denyPatterns;
    protected Map<String, String> headers;
    protected final Map<String, RequestFilterConfig> configCache = new LRUCachingMap<String, RequestFilterConfig>(250);

    public void start(ComponentContext context) {
        List filters = this.getRegistryContributions(FILTER_CONFIG_EP);
        this.grantPatterns = filters.stream().filter(FilterConfigDescriptor::isGrantRule).collect(Collectors.toMap(FilterConfigDescriptor::getName, Function.identity(), (e1, e2) -> e1, LinkedHashMap::new));
        this.denyPatterns = filters.stream().filter(Predicate.not(FilterConfigDescriptor::isGrantRule)).collect(Collectors.toMap(FilterConfigDescriptor::getName, Function.identity(), (e1, e2) -> e1, LinkedHashMap::new));
        this.headers = this.getRegistryContributions(HEADERS_CONFIG_EP).stream().collect(Collectors.toMap(NuxeoHeaderDescriptor::getName, NuxeoHeaderDescriptor::getValue));
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.grantPatterns = null;
        this.denyPatterns = null;
        this.headers = null;
    }

    protected NuxeoCorsFilterDescriptor getFirstMatchingDescriptor(String uri) {
        for (NuxeoCorsFilterDescriptor filterDesc : this.getRegistryContributions(CORS_CONFIG_EP)) {
            Pattern pattern = filterDesc.pattern;
            if (pattern != null && !pattern.matcher(uri).matches()) continue;
            return filterDesc;
        }
        return null;
    }

    @Override
    public CORSFilter getCorsFilterForRequest(HttpServletRequest request) {
        String uri = request.getRequestURI();
        NuxeoCorsFilterDescriptor descriptor = this.getFirstMatchingDescriptor(uri);
        return descriptor == null ? null : descriptor.getFilter();
    }

    @Override
    @Deprecated(since="10.1")
    public FilterConfig getCorsConfigForRequest(HttpServletRequest request) {
        String uri = request.getRequestURI();
        NuxeoCorsFilterDescriptor descriptor = this.getFirstMatchingDescriptor(uri);
        return descriptor != null ? descriptor.buildFilterConfig() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestFilterConfig getConfigForRequest(HttpServletRequest request) {
        Object uri = request.getRequestURI();
        String queryString = request.getQueryString();
        if (queryString != null) {
            uri = (String)uri + "?" + queryString;
        }
        RequestFilterConfig config = null;
        Map<String, RequestFilterConfig> map = this.configCache;
        synchronized (map) {
            config = this.configCache.get(uri);
        }
        if (config == null) {
            config = this.computeConfigForRequest((String)uri);
            map = this.configCache;
            synchronized (map) {
                this.configCache.put((String)uri, config);
            }
        }
        return config;
    }

    public RequestFilterConfig computeConfigForRequest(String uri) {
        Matcher m;
        Pattern pat;
        for (FilterConfigDescriptor desc : this.denyPatterns.values()) {
            pat = desc.getCompiledPattern();
            m = pat.matcher(uri);
            if (!m.matches()) continue;
            return new RequestFilterConfigImpl(false, false, false, false, false, "");
        }
        for (FilterConfigDescriptor desc : this.grantPatterns.values()) {
            pat = desc.getCompiledPattern();
            m = pat.matcher(uri);
            if (!m.matches()) continue;
            return new RequestFilterConfigImpl(desc.useSync(), desc.useTx(), desc.useTxBuffered(), desc.isCached(), desc.isPrivate(), desc.getCacheTime());
        }
        return new RequestFilterConfigImpl(false, false, false, false, false, "");
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }
}

