/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.platform.usermanager.GroupConfig;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.UserManagerDescriptor;
import org.nuxeo.ecm.platform.usermanager.VirtualUser;
import org.nuxeo.ecm.platform.usermanager.VirtualUserDescriptor;
import org.nuxeo.runtime.services.event.Event;

public class FakeUserManagerImpl
implements UserManager {
    private static final long serialVersionUID = 1L;
    String userListingMode;
    String groupListingMode;
    List<String> defaultAdministratorIds;
    List<String> administratorsGroups;
    String defaultGroup;
    String userSortField;
    String groupSortField;
    String userDirectoryName;
    String userEmailField;
    Map<String, UserManager.MatchType> userSearchFields;
    Pattern userPasswordPattern;
    String groupDirectoryName;
    String groupMembersField;
    Map<String, UserManager.MatchType> groupSearchFields;
    String groupSubGroupsField;
    String groupParentGroupsField;
    VirtualUser anonymousUser;
    final Map<String, VirtualUserDescriptor> virtualUsers = new HashMap<String, VirtualUserDescriptor>();

    @Override
    public String getUserListingMode() {
        return this.userListingMode;
    }

    public void setUserListingMode(String userListingMode) {
        this.userListingMode = userListingMode;
    }

    @Override
    public String getGroupListingMode() {
        return this.groupListingMode;
    }

    public void setGroupListingMode(String groupListingMode) {
        this.groupListingMode = groupListingMode;
    }

    @Override
    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    public void setDefaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    @Override
    public String getUserSortField() {
        return this.userSortField;
    }

    public void setUserSortField(String sortField) {
        this.userSortField = sortField;
    }

    public void setGroupSortField(String sortField) {
        this.groupSortField = sortField;
    }

    public void setUserDirectoryName(String userDirectoryName) {
        this.userDirectoryName = userDirectoryName;
    }

    @Override
    public String getUserDirectoryName() {
        return this.userDirectoryName;
    }

    public void setUserEmailField(String userEmailField) {
        this.userEmailField = userEmailField;
    }

    @Override
    public String getUserEmailField() {
        return this.userEmailField;
    }

    public void setUserSearchFields(Set<String> userSearchFields) {
        this.userSearchFields = new LinkedHashMap<String, UserManager.MatchType>();
        for (String searchField : userSearchFields) {
            this.userSearchFields.put(searchField, UserManager.MatchType.SUBSTRING);
        }
    }

    public void setUserSearchFields(Map<String, UserManager.MatchType> userSearchFields) {
        this.userSearchFields = userSearchFields;
    }

    @Override
    public Set<String> getUserSearchFields() {
        return this.userSearchFields.keySet();
    }

    public void setGroupSearchFields(Map<String, UserManager.MatchType> groupSearchFields) {
        this.groupSearchFields = groupSearchFields;
    }

    @Override
    public Set<String> getGroupSearchFields() {
        return this.groupSearchFields.keySet();
    }

    public void setGroupDirectoryName(String groupDirectoryName) {
        this.groupDirectoryName = groupDirectoryName;
    }

    @Override
    public String getGroupDirectoryName() {
        return this.groupDirectoryName;
    }

    public void setGroupMembersField(String groupMembersField) {
        this.groupMembersField = groupMembersField;
    }

    @Override
    public String getGroupMembersField() {
        return this.groupMembersField;
    }

    public void setGroupSubGroupsField(String groupSubGroupsField) {
        this.groupSubGroupsField = groupSubGroupsField;
    }

    @Override
    public String getGroupSubGroupsField() {
        return this.groupSubGroupsField;
    }

    public void setGroupParentGroupsField(String groupParentGroupsField) {
        this.groupParentGroupsField = groupParentGroupsField;
    }

    @Override
    public String getGroupParentGroupsField() {
        return this.groupParentGroupsField;
    }

    @Override
    public Boolean areGroupsReadOnly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean areUsersReadOnly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean checkUsernamePassword(String username, String password) {
        return username.equals(password);
    }

    @Override
    public boolean validatePassword(String password) {
        if (this.userPasswordPattern == null) {
            return true;
        }
        Matcher userPasswordMatcher = this.userPasswordPattern.matcher(password);
        return userPasswordMatcher.find();
    }

    @Override
    public List<String> getGroupsInGroup(String parentId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NuxeoPrincipal getPrincipal(String username, boolean fetchReferences) {
        NuxeoPrincipalImpl principal = new NuxeoPrincipalImpl("Administrator", false, true);
        if (fetchReferences) {
            principal.setGroups(Collections.singletonList("administrators"));
        }
        principal.setEmail("admin@example.com");
        return principal;
    }

    @Override
    public List<String> getTopLevelGroups() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getUsersInGroup(String groupId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getUsersInGroupAndSubGroups(String groupId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModelList searchGroups(String pattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<NuxeoPrincipal> searchPrincipals(String pattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Pattern getUserPasswordPattern() {
        return this.userPasswordPattern;
    }

    public void setUserPasswordPattern(Pattern userPasswordPattern) {
        this.userPasswordPattern = userPasswordPattern;
    }

    public void setAnonymousUser(VirtualUser anonymousUser) {
        this.anonymousUser = anonymousUser;
    }

    public void setVirtualUsers(Map<String, VirtualUserDescriptor> virtualUsers) {
        this.virtualUsers.clear();
        if (virtualUsers != null) {
            this.virtualUsers.putAll(virtualUsers);
        }
    }

    @Override
    public String getAnonymousUserId() {
        if (this.anonymousUser == null) {
            return null;
        }
        return this.anonymousUser.getId();
    }

    @Override
    public String getDigestAuthDirectory() {
        return null;
    }

    @Override
    public String getDigestAuthRealm() {
        return null;
    }

    @Override
    public void setConfiguration(UserManagerDescriptor descriptor) {
        this.setDefaultGroup(descriptor.defaultGroup);
        this.defaultAdministratorIds = descriptor.defaultAdministratorIds;
        this.administratorsGroups = descriptor.administratorsGroups;
        this.setUserSortField(descriptor.userSortField);
        this.setGroupSortField(descriptor.groupSortField);
        this.setUserListingMode(descriptor.userListingMode);
        this.setGroupListingMode(descriptor.groupListingMode);
        this.setUserDirectoryName(descriptor.userDirectoryName);
        this.setUserEmailField(descriptor.userEmailField);
        this.setUserSearchFields(descriptor.userSearchFields);
        this.setUserPasswordPattern(descriptor.userPasswordPattern);
        this.setGroupDirectoryName(descriptor.groupDirectoryName);
        this.setGroupMembersField(descriptor.groupMembersField);
        this.setGroupSubGroupsField(descriptor.groupSubGroupsField);
        this.setGroupParentGroupsField(descriptor.groupParentGroupsField);
        this.setGroupSearchFields(descriptor.groupSearchFields);
        this.setAnonymousUser(descriptor.anonymousUser);
        this.setVirtualUsers(descriptor.virtualUsers);
    }

    @Override
    public DocumentModel getBareUserModel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModel createGroup(DocumentModel groupModel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModel createUser(DocumentModel userModel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteGroup(DocumentModel groupModel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteGroup(String groupId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteUser(DocumentModel userModel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteUser(String userId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModel getBareGroupModel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NuxeoGroup getGroup(String groupName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getGroupIds() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getUserIds() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModelList searchGroups(Map<String, Serializable> filter, Set<String> fulltext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModelList searchGroups(QueryBuilder queryBuilder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModelList searchUsers(Map<String, Serializable> filter, Set<String> fulltext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModelList searchUsers(String pattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModelList searchUsers(QueryBuilder queryBuilder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateGroup(DocumentModel groupModel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateUser(DocumentModel userModel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModel getGroupModel(String groupName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModel getUserModel(String userName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getGroupIdField() {
        return "groupname";
    }

    @Override
    public String getGroupLabelField() {
        return "grouplabel";
    }

    @Override
    public String getGroupSchemaName() {
        return "group";
    }

    @Override
    public String getUserIdField() {
        return "username";
    }

    @Override
    public String getUserSchemaName() {
        return "user";
    }

    @Override
    public List<String> getAdministratorsGroups() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] getUsersForPermission(String perm, ACP acp) {
        throw new UnsupportedOperationException();
    }

    public Principal authenticate(String name, String password) {
        return this.checkUsernamePassword(name, password) ? this.getPrincipal(name) : null;
    }

    public void handleEvent(Event event) {
    }

    @Override
    public List<String> getAncestorGroups(String groupId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getDescendantGroups(String groupId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GroupConfig getGroupConfig() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void notifyUserChanged(String userName, String eventId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void notifyGroupChanged(String groupName, String eventId, List<String> ancestorGroupNames) {
        throw new UnsupportedOperationException();
    }
}

