/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelComparator;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.AdministratorGroupsProvider;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheManagement;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.UnboundEventContext;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByExprs;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.Predicates;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.memory.MemoryDirectoryExpressionEvaluator;
import org.nuxeo.ecm.platform.usermanager.DefaultUserMultiTenantManagement;
import org.nuxeo.ecm.platform.usermanager.GroupConfig;
import org.nuxeo.ecm.platform.usermanager.MultiTenantUserManager;
import org.nuxeo.ecm.platform.usermanager.NuxeoGroupImpl;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserConfig;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.UserManagerDescriptor;
import org.nuxeo.ecm.platform.usermanager.UserMultiTenantManagement;
import org.nuxeo.ecm.platform.usermanager.VirtualUser;
import org.nuxeo.ecm.platform.usermanager.VirtualUserDescriptor;
import org.nuxeo.ecm.platform.usermanager.exceptions.GroupAlreadyExistsException;
import org.nuxeo.ecm.platform.usermanager.exceptions.InvalidPasswordException;
import org.nuxeo.ecm.platform.usermanager.exceptions.UserAlreadyExistsException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventService;

public class UserManagerImpl
implements UserManager,
MultiTenantUserManager,
AdministratorGroupsProvider {
    private static final String VALIDATE_PASSWORD_PARAM = "nuxeo.usermanager.check.password";
    protected static final String SEARCH_ESCAPE_COMPAT_PARAM = "nuxeo.usermanager.search.escape.compat";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(UserManagerImpl.class);
    public static final String USERMANAGER_TOPIC = "usermanager";
    public static final String USERCHANGED_EVENT_ID = "user_changed";
    public static final String USERCREATED_EVENT_ID = "user_created";
    public static final String USERDELETED_EVENT_ID = "user_deleted";
    public static final String USERMODIFIED_EVENT_ID = "user_modified";
    public static final String GROUPCHANGED_EVENT_ID = "group_changed";
    public static final String GROUPCREATED_EVENT_ID = "group_created";
    public static final String GROUPDELETED_EVENT_ID = "group_deleted";
    public static final String GROUPMODIFIED_EVENT_ID = "group_modified";
    public static final String DEFAULT_ANONYMOUS_USER_ID = "Anonymous";
    public static final String VIRTUAL_FIELD_FILTER_PREFIX = "__";
    public static final String INVALIDATE_PRINCIPAL_EVENT_ID = "invalidatePrincipal";
    public static final String INVALIDATE_ALL_PRINCIPALS_EVENT_ID = "invalidateAllPrincipals";
    public static final String USER_GROUP_CATEGORY = "userGroup";
    public static final String ID_PROPERTY_KEY = "id";
    public static final String ANCESTOR_GROUPS_PROPERTY_KEY = "ancestorGroups";
    public static final String USER_HAS_PARTIAL_CONTENT = "userHasPartialContent";
    protected final DirectoryService dirService;
    protected final CacheService cacheService;
    protected Cache principalCache = null;
    public UserMultiTenantManagement multiTenantManagement = new DefaultUserMultiTenantManagement();
    protected UserConfig userConfig;
    protected GroupConfig groupConfig;
    protected String userDirectoryName;
    protected String userSchemaName;
    protected String userIdField;
    protected String userEmailField;
    protected Map<String, UserManager.MatchType> userSearchFields;
    protected String groupDirectoryName;
    protected String groupSchemaName;
    protected String groupIdField;
    protected String groupLabelField;
    protected String groupMembersField;
    protected String groupSubGroupsField;
    protected String groupParentGroupsField;
    protected String groupSortField;
    protected Map<String, UserManager.MatchType> groupSearchFields;
    protected String defaultGroup;
    protected List<String> administratorIds;
    protected List<String> administratorGroups;
    protected Boolean disableDefaultAdministratorsGroup;
    protected String userSortField;
    protected String userListingMode;
    protected String groupListingMode;
    protected Pattern userPasswordPattern;
    protected VirtualUser anonymousUser;
    protected String digestAuthDirectory;
    protected String digestAuthRealm;
    protected final Map<String, VirtualUserDescriptor> virtualUsers;

    public UserManagerImpl() {
        this.dirService = (DirectoryService)Framework.getService(DirectoryService.class);
        this.cacheService = (CacheService)Framework.getService(CacheService.class);
        this.virtualUsers = new HashMap<String, VirtualUserDescriptor>();
        this.userConfig = new UserConfig();
    }

    @Override
    public void setConfiguration(UserManagerDescriptor descriptor) {
        this.defaultGroup = descriptor.defaultGroup;
        this.administratorIds = descriptor.defaultAdministratorIds;
        this.disableDefaultAdministratorsGroup = false;
        if (descriptor.disableDefaultAdministratorsGroup != null) {
            this.disableDefaultAdministratorsGroup = descriptor.disableDefaultAdministratorsGroup;
        }
        this.administratorGroups = new ArrayList<String>();
        if (!this.disableDefaultAdministratorsGroup.booleanValue()) {
            this.administratorGroups.add("administrators");
        }
        if (descriptor.administratorsGroups != null) {
            this.administratorGroups.addAll(descriptor.administratorsGroups);
        }
        if (this.administratorGroups.isEmpty()) {
            log.warn((Object)"No administrators group has been defined: at least one should be set to avoid lockups when blocking rights for instance");
        }
        this.userSortField = descriptor.userSortField;
        this.groupSortField = descriptor.groupSortField;
        this.userListingMode = descriptor.userListingMode;
        this.groupListingMode = descriptor.groupListingMode;
        this.userEmailField = descriptor.userEmailField;
        this.userSearchFields = descriptor.userSearchFields;
        this.userPasswordPattern = descriptor.userPasswordPattern;
        this.groupLabelField = descriptor.groupLabelField;
        this.groupMembersField = descriptor.groupMembersField;
        this.groupSubGroupsField = descriptor.groupSubGroupsField;
        this.groupParentGroupsField = descriptor.groupParentGroupsField;
        this.groupSearchFields = descriptor.groupSearchFields;
        this.anonymousUser = descriptor.anonymousUser;
        this.setUserDirectoryName(descriptor.userDirectoryName);
        this.setGroupDirectoryName(descriptor.groupDirectoryName);
        this.setVirtualUsers(descriptor.virtualUsers);
        this.digestAuthDirectory = descriptor.digestAuthDirectory;
        this.digestAuthRealm = descriptor.digestAuthRealm;
        this.userConfig = new UserConfig();
        this.userConfig.emailKey = this.userEmailField;
        this.userConfig.schemaName = this.userSchemaName;
        this.userConfig.nameKey = this.userIdField;
        this.groupConfig = new GroupConfig();
        this.groupConfig.schemaName = this.groupSchemaName;
        this.groupConfig.idField = this.groupIdField;
        this.groupConfig.labelField = this.groupLabelField;
        this.groupConfig.membersField = this.groupMembersField;
        this.groupConfig.subGroupsField = this.groupSubGroupsField;
        this.groupConfig.parentGroupsField = this.groupParentGroupsField;
        if (this.cacheService != null && descriptor.userCacheName != null) {
            this.principalCache = this.cacheService.getCache(descriptor.userCacheName);
            this.invalidateAllPrincipals();
        }
    }

    protected void setUserDirectoryName(String userDirectoryName) {
        this.userDirectoryName = userDirectoryName;
        this.userSchemaName = this.dirService.getDirectorySchema(userDirectoryName);
        this.userIdField = this.dirService.getDirectoryIdField(userDirectoryName);
    }

    @Override
    public String getUserDirectoryName() {
        return this.userDirectoryName;
    }

    @Override
    public String getUserIdField() {
        return this.userIdField;
    }

    @Override
    public String getUserSchemaName() {
        return this.userSchemaName;
    }

    @Override
    public String getUserEmailField() {
        return this.userEmailField;
    }

    @Override
    public Set<String> getUserSearchFields() {
        return Collections.unmodifiableSet(this.userSearchFields.keySet());
    }

    @Override
    public Set<String> getGroupSearchFields() {
        return Collections.unmodifiableSet(this.groupSearchFields.keySet());
    }

    protected void setGroupDirectoryName(String groupDirectoryName) {
        this.groupDirectoryName = groupDirectoryName;
        this.groupSchemaName = this.dirService.getDirectorySchema(groupDirectoryName);
        this.groupIdField = this.dirService.getDirectoryIdField(groupDirectoryName);
    }

    @Override
    public String getGroupDirectoryName() {
        return this.groupDirectoryName;
    }

    @Override
    public String getGroupIdField() {
        return this.groupIdField;
    }

    @Override
    public String getGroupLabelField() {
        return this.groupLabelField;
    }

    @Override
    public String getGroupSchemaName() {
        return this.groupSchemaName;
    }

    @Override
    public String getGroupMembersField() {
        return this.groupMembersField;
    }

    @Override
    public String getGroupSubGroupsField() {
        return this.groupSubGroupsField;
    }

    @Override
    public String getGroupParentGroupsField() {
        return this.groupParentGroupsField;
    }

    @Override
    public String getUserListingMode() {
        return this.userListingMode;
    }

    @Override
    public String getGroupListingMode() {
        return this.groupListingMode;
    }

    @Override
    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    @Override
    public Pattern getUserPasswordPattern() {
        return this.userPasswordPattern;
    }

    @Override
    public String getAnonymousUserId() {
        if (this.anonymousUser == null) {
            return null;
        }
        String anonymousUserId = this.anonymousUser.getId();
        if (anonymousUserId == null) {
            return DEFAULT_ANONYMOUS_USER_ID;
        }
        return anonymousUserId;
    }

    protected void setVirtualUsers(Map<String, VirtualUserDescriptor> virtualUsers) {
        this.virtualUsers.clear();
        if (virtualUsers != null) {
            this.virtualUsers.putAll(virtualUsers);
        }
    }

    @Override
    public boolean checkUsernamePassword(String username, String password) {
        if (username == null || password == null) {
            log.warn((Object)"Trying to authenticate against null username or password");
            return false;
        }
        String anonymousUserId = this.getAnonymousUserId();
        if (username.equals(anonymousUserId)) {
            log.warn((Object)String.format("Trying to authenticate anonymous user (%s)", anonymousUserId));
            return false;
        }
        if (this.virtualUsers.containsKey(username)) {
            VirtualUser user = this.virtualUsers.get(username);
            String expected = user.getPassword();
            if (expected == null) {
                return false;
            }
            return expected.equals(password);
        }
        String userDirName = "userDirectory".equals(this.userDirectoryName) && this.dirService.getDirectory("userAuthentication") != null ? "userAuthentication" : this.userDirectoryName;
        try (Session userDir = this.dirService.open(userDirName);){
            if (!userDir.isAuthenticating()) {
                log.error((Object)("Trying to authenticate against a non authenticating directory: " + userDirName));
                boolean bl = false;
                return bl;
            }
            boolean authenticated = userDir.authenticate(username, password);
            if (authenticated) {
                Framework.doPrivileged(() -> this.syncDigestAuthPassword(username, password));
            }
            boolean bl = authenticated;
            return bl;
        }
    }

    protected void syncDigestAuthPassword(String username, String password) {
        if (StringUtils.isEmpty((CharSequence)this.digestAuthDirectory) || StringUtils.isEmpty((CharSequence)this.digestAuthRealm) || username == null || password == null) {
            return;
        }
        String ha1 = UserManagerImpl.encodeDigestAuthPassword(username, this.digestAuthRealm, password);
        try (Session dir = this.dirService.open(this.digestAuthDirectory);){
            dir.setReadAllColumns(true);
            String schema = this.dirService.getDirectorySchema(this.digestAuthDirectory);
            DocumentModel entry = dir.getEntry(username, true);
            if (entry == null) {
                entry = this.getDigestAuthModel();
                entry.setProperty(schema, dir.getIdField(), (Object)username);
                entry.setProperty(schema, dir.getPasswordField(), (Object)ha1);
                dir.createEntry(entry);
                log.debug((Object)("Created digest auth password for user:" + username));
            } else {
                String storedHa1 = (String)entry.getProperty(schema, dir.getPasswordField());
                if (!ha1.equals(storedHa1)) {
                    entry.setProperty(schema, dir.getPasswordField(), (Object)ha1);
                    dir.updateEntry(entry);
                    log.debug((Object)("Updated digest auth password for user:" + username));
                }
            }
        }
        catch (DirectoryException e) {
            log.warn((Object)"Digest auth password not synchronized, check your configuration", (Throwable)e);
        }
    }

    protected DocumentModel getDigestAuthModel() {
        String schema = this.dirService.getDirectorySchema(this.digestAuthDirectory);
        return BaseSession.createEntryModel(null, (String)schema, null, null);
    }

    public static String encodeDigestAuthPassword(String username, String realm, String password) {
        String a1 = username + ":" + realm + ":" + password;
        return DigestUtils.md5Hex((String)a1);
    }

    @Override
    public String getDigestAuthDirectory() {
        return this.digestAuthDirectory;
    }

    @Override
    public String getDigestAuthRealm() {
        return this.digestAuthRealm;
    }

    @Override
    public boolean validatePassword(String password) {
        if (this.userPasswordPattern == null) {
            return true;
        }
        Matcher userPasswordMatcher = this.userPasswordPattern.matcher(password);
        return userPasswordMatcher.find();
    }

    protected NuxeoPrincipal makeAnonymousPrincipal() {
        DocumentModel userEntry = this.makeVirtualUserEntry(this.getAnonymousUserId(), this.anonymousUser);
        return this.makePrincipal(userEntry, true, this.anonymousUser.getGroups());
    }

    protected NuxeoPrincipal makeVirtualPrincipal(VirtualUser user) {
        DocumentModel userEntry = this.makeVirtualUserEntry(user.getId(), user);
        return this.makePrincipal(userEntry, false, user.getGroups());
    }

    protected NuxeoPrincipal makeTransientPrincipal(String username) {
        DocumentModel userEntry = BaseSession.createEntryModel(null, (String)this.userSchemaName, (String)username, null);
        userEntry.setProperty(this.userSchemaName, this.userIdField, (Object)username);
        NuxeoPrincipal principal = this.makePrincipal(userEntry, false, true, null);
        String[] parts = username.split("/");
        String email = parts[1];
        principal.setFirstName(email);
        principal.setEmail(email);
        return principal;
    }

    protected DocumentModel makeVirtualUserEntry(String id, VirtualUser user) {
        DocumentModel userEntry = BaseSession.createEntryModel(null, (String)this.userSchemaName, (String)id, null);
        userEntry.setProperty(this.userSchemaName, this.userIdField, (Object)id);
        for (Map.Entry<String, Serializable> prop : user.getProperties().entrySet()) {
            try {
                userEntry.setProperty(this.userSchemaName, prop.getKey(), (Object)prop.getValue());
            }
            catch (PropertyNotFoundException ce) {
                log.error((Object)("Property: " + prop.getKey() + " does not exists. Check your UserService configuration."), (Throwable)ce);
            }
        }
        return userEntry;
    }

    protected NuxeoPrincipal makePrincipal(DocumentModel userEntry) {
        return this.makePrincipal(userEntry, false, null);
    }

    protected NuxeoPrincipal makePrincipal(DocumentModel userEntry, boolean anonymous, List<String> groups) {
        return this.makePrincipal(userEntry, anonymous, false, groups);
    }

    protected NuxeoPrincipal makePrincipal(DocumentModel userEntry, boolean anonymous, boolean isTransient, List<String> groups) {
        boolean admin = false;
        String username = userEntry.getId();
        LinkedList<String> virtualGroups = new LinkedList<String>();
        if (this.defaultGroup != null && !anonymous && !isTransient) {
            virtualGroups.add(this.defaultGroup);
        }
        if (groups != null && !isTransient) {
            virtualGroups.addAll(groups);
        }
        if (this.administratorIds != null && this.administratorIds.contains(username)) {
            admin = true;
            if (this.administratorGroups != null) {
                virtualGroups.addAll(this.administratorGroups);
            }
        }
        NuxeoPrincipalImpl principal = new NuxeoPrincipalImpl(username, anonymous, admin, false);
        principal.setConfig(this.userConfig);
        principal.setModel(userEntry, false);
        principal.setVirtualGroups(virtualGroups, true);
        List<String> roles = Collections.singletonList("regular");
        principal.setRoles(roles);
        return principal;
    }

    protected boolean useCache() {
        return this.principalCache != null;
    }

    @Override
    public NuxeoPrincipal getPrincipal(String username, boolean fetchReferences) {
        if (this.useCache() && fetchReferences) {
            return this.getPrincipalUsingCache(username);
        }
        return this.getPrincipal(username, null, fetchReferences);
    }

    protected NuxeoPrincipal getPrincipalUsingCache(String username) {
        NuxeoPrincipal ret = (NuxeoPrincipal)this.principalCache.get(username);
        if (ret == null) {
            ret = this.getPrincipal(username, null);
            if (ret == null) {
                return ret;
            }
            ((CacheManagement)this.principalCache).putLocal(username, (Serializable)ret);
        }
        return ((NuxeoPrincipalImpl)ret).cloneTransferable();
    }

    @Override
    public DocumentModel getUserModel(String userName) {
        return this.getUserModel(userName, null);
    }

    @Override
    public DocumentModel getBareUserModel() {
        String schema = this.dirService.getDirectorySchema(this.userDirectoryName);
        return BaseSession.createEntryModel(null, (String)schema, null, null);
    }

    @Override
    public NuxeoGroup getGroup(String groupName) {
        return this.getGroup(groupName, null);
    }

    protected NuxeoGroup getGroup(String groupName, DocumentModel context) {
        DocumentModel groupEntry = this.getGroupModel(groupName, context);
        if (groupEntry != null) {
            return this.makeGroup(groupEntry);
        }
        return null;
    }

    @Override
    public DocumentModel getGroupModel(String groupName) {
        return this.getGroupModel(groupName, null);
    }

    protected NuxeoGroup makeGroup(DocumentModel groupEntry) {
        return new NuxeoGroupImpl(groupEntry, this.groupConfig);
    }

    @Override
    public List<String> getTopLevelGroups() {
        return this.getTopLevelGroups(null);
    }

    @Override
    public List<String> getGroupsInGroup(String parentId) {
        NuxeoGroup group = this.getGroup(parentId, null);
        if (group != null) {
            return group.getMemberGroups();
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getUsersInGroup(String groupId) {
        return this.getGroup(groupId).getMemberUsers();
    }

    @Override
    public List<String> getUsersInGroupAndSubGroups(String groupId) {
        return this.getUsersInGroupAndSubGroups(groupId, null);
    }

    protected void appendSubgroups(String groupId, Set<String> groups, DocumentModel context) {
        List<String> groupsToAppend = this.getDescendantGroups(groupId);
        groups.addAll(groupsToAppend);
    }

    protected boolean isAnonymousMatching(Map<String, Serializable> filter, Set<String> fulltext) {
        String anonymousUserId = this.getAnonymousUserId();
        if (anonymousUserId == null) {
            return false;
        }
        if (filter == null || filter.isEmpty()) {
            return true;
        }
        Map<String, Serializable> anonymousUserMap = this.anonymousUser.getProperties();
        anonymousUserMap.put(this.userIdField, (Serializable)((Object)anonymousUserId));
        for (Map.Entry<String, Serializable> e : filter.entrySet()) {
            String fieldName = e.getKey();
            Serializable expected = e.getValue();
            Serializable value = anonymousUserMap.get(fieldName);
            if (!(value == null ? expected != null : (fulltext != null && fulltext.contains(fieldName) ? !value.toString().toLowerCase().startsWith(expected.toString().toLowerCase()) : !value.equals(expected)))) continue;
            return false;
        }
        return true;
    }

    protected boolean isAnonymousMatching(QueryBuilder queryBuilder, Directory dir) {
        String anonymousUserId = this.getAnonymousUserId();
        if (anonymousUserId == null) {
            return false;
        }
        MultiExpression expression = queryBuilder.predicate();
        if (expression.predicates.isEmpty()) {
            return true;
        }
        Map<String, Serializable> entry = this.anonymousUser.getProperties();
        entry.put(this.userIdField, (Serializable)((Object)anonymousUserId));
        return new MemoryDirectoryExpressionEvaluator(dir).matchesEntry((Expression)expression, entry);
    }

    @Override
    public List<NuxeoPrincipal> searchPrincipals(String pattern) {
        DocumentModelList entries = this.searchUsers(pattern);
        ArrayList<NuxeoPrincipal> principals = new ArrayList<NuxeoPrincipal>(entries.size());
        for (DocumentModel entry : entries) {
            principals.add(this.makePrincipal(entry));
        }
        return principals;
    }

    @Override
    public DocumentModelList searchGroups(String pattern) {
        return this.searchGroups(pattern, null);
    }

    @Override
    public String getUserSortField() {
        return this.userSortField;
    }

    protected Map<String, String> getUserSortMap() {
        return this.getDirectorySortMap(this.userSortField, this.userIdField);
    }

    protected OrderByExpr getUserOrderBy() {
        String sortField = StringUtils.defaultString((String)this.userSortField, (String)this.userIdField);
        return OrderByExprs.asc((String)sortField);
    }

    protected Map<String, String> getGroupSortMap() {
        return this.getDirectorySortMap(this.groupSortField, this.groupIdField);
    }

    protected OrderByExpr getGroupOrderBy() {
        String sortField = StringUtils.defaultString((String)this.groupSortField, (String)this.groupIdField);
        return OrderByExprs.asc((String)sortField);
    }

    protected Map<String, String> getDirectorySortMap(String descriptorSortField, String fallBackField) {
        String sortField = descriptorSortField != null ? descriptorSortField : fallBackField;
        HashMap<String, String> orderBy = new HashMap<String, String>();
        orderBy.put(sortField, "asc");
        return orderBy;
    }

    protected void notifyCore(String userOrGroupId, String eventId) {
        this.notifyCore(userOrGroupId, eventId, null);
    }

    protected void notifyCore(String userOrGroupId, String eventId, List<String> ancestorGroupIds) {
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        eventProperties.put("category", USER_GROUP_CATEGORY);
        eventProperties.put(ID_PROPERTY_KEY, userOrGroupId);
        if (ancestorGroupIds != null) {
            eventProperties.put(ANCESTOR_GROUPS_PROPERTY_KEY, (Serializable)((Object)ancestorGroupIds));
        }
        NuxeoPrincipal principal = NuxeoPrincipal.getCurrent();
        UnboundEventContext envContext = new UnboundEventContext(principal, eventProperties);
        envContext.setProperties(eventProperties);
        EventProducer eventProducer = (EventProducer)Framework.getService(EventProducer.class);
        eventProducer.fireEvent(envContext.newEvent(eventId));
    }

    protected void notifyRuntime(String userOrGroupName, String eventId) {
        EventService eventService = (EventService)Framework.getService(EventService.class);
        eventService.sendEvent(new Event(USERMANAGER_TOPIC, eventId, (Object)this, (Object)userOrGroupName));
    }

    @Override
    public void notifyUserChanged(String userName, String eventId) {
        this.invalidatePrincipal(userName);
        this.notifyRuntime(userName, USERCHANGED_EVENT_ID);
        if (eventId != null) {
            this.notifyRuntime(userName, eventId);
            this.notifyCore(userName, eventId);
        }
    }

    protected void invalidatePrincipal(String userName) {
        if (this.useCache()) {
            this.principalCache.invalidate(userName);
        }
    }

    @Override
    public void notifyGroupChanged(String groupName, String eventId, List<String> ancestorGroupNames) {
        this.invalidateAllPrincipals();
        this.notifyRuntime(groupName, GROUPCHANGED_EVENT_ID);
        if (eventId != null) {
            this.notifyRuntime(groupName, eventId);
            this.notifyCore(groupName, eventId, ancestorGroupNames);
        }
    }

    protected void invalidateAllPrincipals() {
        if (this.useCache()) {
            this.principalCache.invalidateAll();
        }
    }

    @Override
    public Boolean areGroupsReadOnly() {
        Boolean bl;
        block8: {
            Session groupDir = this.dirService.open(this.groupDirectoryName);
            try {
                bl = groupDir.isReadOnly();
                if (groupDir == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (groupDir != null) {
                        try {
                            groupDir.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DirectoryException e) {
                    log.error((Object)e);
                    return false;
                }
            }
            groupDir.close();
        }
        return bl;
    }

    @Override
    public Boolean areUsersReadOnly() {
        Boolean bl;
        block8: {
            Session userDir = this.dirService.open(this.userDirectoryName);
            try {
                bl = userDir.isReadOnly();
                if (userDir == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (userDir != null) {
                        try {
                            userDir.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DirectoryException e) {
                    log.error((Object)e);
                    return false;
                }
            }
            userDir.close();
        }
        return bl;
    }

    protected void checkGrouId(DocumentModel groupModel) {
        Object groupIdValue = groupModel.getProperty(this.groupSchemaName, this.groupIdField);
        if (groupIdValue != null) {
            groupModel.setProperty(this.groupSchemaName, this.groupIdField, (Object)groupIdValue.toString().trim());
        }
    }

    protected String getGroupId(DocumentModel groupModel) {
        Object groupIdValue = groupModel.getProperty(this.groupSchemaName, this.groupIdField);
        if (groupIdValue != null && !(groupIdValue instanceof String)) {
            throw new NuxeoException("Invalid group id " + groupIdValue);
        }
        return (String)groupIdValue;
    }

    protected void checkUserId(DocumentModel userModel) {
        Object userIdValue = userModel.getProperty(this.userSchemaName, this.userIdField);
        if (userIdValue != null) {
            userModel.setProperty(this.userSchemaName, this.userIdField, (Object)userIdValue.toString().trim());
        }
    }

    protected String getUserId(DocumentModel userModel) {
        Object userIdValue = userModel.getProperty(this.userSchemaName, this.userIdField);
        if (userIdValue != null && !(userIdValue instanceof String)) {
            throw new NuxeoException("Invalid user id " + userIdValue);
        }
        return (String)userIdValue;
    }

    @Override
    public DocumentModel createGroup(DocumentModel groupModel) {
        return this.createGroup(groupModel, null);
    }

    @Override
    public DocumentModel createUser(DocumentModel userModel) {
        return this.createUser(userModel, null);
    }

    @Override
    public void deleteGroup(String groupId) {
        this.deleteGroup(groupId, null);
    }

    @Override
    public void deleteGroup(DocumentModel groupModel) {
        this.deleteGroup(groupModel, null);
    }

    @Override
    public void deleteUser(String userId) {
        this.deleteUser(userId, null);
    }

    @Override
    public void deleteUser(DocumentModel userModel) {
        String userId = this.getUserId(userModel);
        this.deleteUser(userId);
    }

    @Override
    public List<String> getGroupIds() {
        try (Session groupDir = this.dirService.open(this.groupDirectoryName);){
            List groupIds = groupDir.getProjection(Collections.emptyMap(), groupDir.getIdField());
            Collections.sort(groupIds);
            List list = groupIds;
            return list;
        }
    }

    @Override
    public List<String> getUserIds() {
        return this.getUserIds(null);
    }

    protected void removeVirtualFilters(Map<String, Serializable> filter) {
        if (filter == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(filter.keySet());
        for (String key : keys) {
            if (!key.startsWith(VIRTUAL_FIELD_FILTER_PREFIX)) continue;
            filter.remove(key);
        }
    }

    protected QueryBuilder getQueryForPattern(String pattern, String dirName, Map<String, UserManager.MatchType> searchFields, OrderByExpr orderBy) {
        QueryBuilder queryBuilder = new QueryBuilder();
        if (!StringUtils.isBlank((CharSequence)pattern)) {
            String likePattern;
            pattern = pattern.trim().toLowerCase();
            if (!this.useSearchEscapeCompat()) {
                likePattern = pattern.replace("\\", "\\\\");
                likePattern = likePattern.replace("%", "\\%");
                likePattern = likePattern.replace("_", "\\_");
            } else {
                likePattern = pattern;
            }
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            for (Map.Entry<String, UserManager.MatchType> fieldEntry : searchFields.entrySet()) {
                Predicate predicate;
                String key = fieldEntry.getKey();
                if (fieldEntry.getValue() == UserManager.MatchType.SUBSTRING) {
                    String value;
                    Directory dir = this.dirService.getDirectory(dirName);
                    BaseDirectoryDescriptor.SubstringMatchType substringMatchType = dir.getDescriptor().getSubstringMatchType();
                    switch (substringMatchType) {
                        case subany: {
                            value = "%" + likePattern + "%";
                            break;
                        }
                        case subinitial: {
                            value = likePattern + "%";
                            break;
                        }
                        case subfinal: {
                            value = "%" + likePattern;
                            break;
                        }
                        default: {
                            throw new IllegalStateException(substringMatchType.toString());
                        }
                    }
                    predicate = Predicates.ilike((String)key, (Object)value);
                } else {
                    predicate = Predicates.eq((String)key, (Object)pattern);
                }
                predicates.add(predicate);
            }
            queryBuilder.filter(new MultiExpression(Operator.OR, predicates));
        }
        queryBuilder.order(orderBy);
        return queryBuilder;
    }

    @Override
    public DocumentModelList searchGroups(Map<String, Serializable> filter, Set<String> fulltext) {
        return this.searchGroups(filter, fulltext, null);
    }

    @Override
    public DocumentModelList searchGroups(QueryBuilder queryBuilder) {
        return this.searchGroups(queryBuilder, null);
    }

    @Override
    public DocumentModelList searchUsers(String pattern) {
        return this.searchUsers(pattern, null);
    }

    @Override
    public DocumentModelList searchUsers(Map<String, Serializable> filter, Set<String> fulltext) {
        return this.searchUsers(filter, fulltext, this.getUserSortMap(), null);
    }

    @Override
    public DocumentModelList searchUsers(QueryBuilder queryBuilder) {
        return this.searchUsers(queryBuilder, null);
    }

    @Override
    public void updateGroup(DocumentModel groupModel) {
        this.updateGroup(groupModel, null);
    }

    @Override
    public void updateUser(DocumentModel userModel) {
        this.updateUser(userModel, null);
    }

    @Override
    public DocumentModel getBareGroupModel() {
        String schema = this.dirService.getDirectorySchema(this.groupDirectoryName);
        return BaseSession.createEntryModel(null, (String)schema, null, null);
    }

    @Override
    public List<String> getAdministratorsGroups() {
        return this.administratorGroups;
    }

    protected List<String> getLeafPermissions(String perm) {
        ArrayList<String> permissions = new ArrayList<String>();
        PermissionProvider permissionProvider = (PermissionProvider)Framework.getService(PermissionProvider.class);
        String[] subpermissions = permissionProvider.getSubPermissions(perm);
        if (subpermissions == null || subpermissions.length <= 0) {
            permissions.add(perm);
            return permissions;
        }
        for (String subperm : subpermissions) {
            permissions.addAll(this.getLeafPermissions(subperm));
        }
        return permissions;
    }

    @Override
    public String[] getUsersForPermission(String perm, ACP acp) {
        return this.getUsersForPermission(perm, acp, null);
    }

    public Principal authenticate(String name, String password) {
        return this.checkUsernamePassword(name, password) ? this.getPrincipal(name) : null;
    }

    public DocumentModelList searchUsers(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, DocumentModel context) {
        try (Session userDir = this.dirService.open(this.userDirectoryName, context);){
            this.removeVirtualFilters(filter);
            DocumentModelList entries = userDir.query(filter, fulltext, null, false);
            if (this.isAnonymousMatching(filter, fulltext)) {
                entries.add((Object)this.makeVirtualUserEntry(this.getAnonymousUserId(), this.anonymousUser));
            }
            if (orderBy != null && !orderBy.isEmpty()) {
                entries.sort((Comparator)new DocumentModelComparator(this.userSchemaName, orderBy));
            }
            DocumentModelList documentModelList = entries;
            return documentModelList;
        }
    }

    @Override
    public List<String> getUsersInGroup(String groupId, DocumentModel context) {
        String storeGroupId = this.multiTenantManagement.groupnameTranformer(this, groupId, context);
        return this.getGroup(storeGroupId).getMemberUsers();
    }

    @Override
    public DocumentModelList searchUsers(String pattern, DocumentModel context) {
        QueryBuilder queryBuilder = this.getQueryForPattern(pattern, this.userDirectoryName, this.userSearchFields, this.getUserOrderBy());
        return this.searchUsers(queryBuilder, context);
    }

    @Override
    public DocumentModelList searchUsers(QueryBuilder queryBuilder, DocumentModel context) {
        Directory dir = this.dirService.getDirectory(this.userDirectoryName, context);
        try (Session session = dir.getSession();){
            if (this.isAnonymousMatching(queryBuilder, dir)) {
                DocumentModel anonymousEntry = this.makeVirtualUserEntry(this.getAnonymousUserId(), this.anonymousUser);
                List<DocumentModel> virtualEntries = Collections.singletonList(anonymousEntry);
                DocumentModelList documentModelList = this.queryWithVirtualEntries(session, queryBuilder, virtualEntries);
                return documentModelList;
            }
            DocumentModelList documentModelList = session.query(queryBuilder, false);
            return documentModelList;
        }
    }

    protected DocumentModelList queryWithVirtualEntries(Session session, QueryBuilder queryBuilder, List<DocumentModel> virtualEntries) {
        AbstractDirectory dir = (AbstractDirectory)((BaseSession)session).getDirectory();
        DocumentModelList entries = session.query(queryBuilder, false);
        int limit = Math.max(0, (int)queryBuilder.limit());
        int offset = Math.max(0, (int)queryBuilder.offset());
        boolean countTotal = queryBuilder.countTotal();
        OrderByList orders = queryBuilder.orders();
        int size = entries.size();
        long totalSize = entries.totalSize();
        if (offset == 0 && (limit == 0 || size + virtualEntries.size() <= limit)) {
            entries.addAll(virtualEntries);
            if (totalSize >= 0L) {
                ((DocumentModelListImpl)entries).setTotalSize(totalSize + (long)virtualEntries.size());
            }
            dir.orderEntries((List)entries, AbstractDirectory.makeOrderBy((OrderByList)orders));
            return entries;
        }
        queryBuilder = new QueryBuilder(queryBuilder).limit(0L).offset(0L).orders(Collections.emptyList());
        entries = session.query(queryBuilder, false);
        entries.addAll(virtualEntries);
        if (!orders.isEmpty()) {
            dir.orderEntries((List)entries, AbstractDirectory.makeOrderBy((OrderByList)orders));
        }
        entries = ((BaseSession)session).applyQueryLimits(entries, limit, offset);
        if (!countTotal) {
            ((DocumentModelListImpl)entries).setTotalSize(-2L);
        }
        return entries;
    }

    @Override
    public DocumentModelList searchUsers(Map<String, Serializable> filter, Set<String> fulltext, DocumentModel context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getGroupIds(DocumentModel context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModelList searchGroups(Map<String, Serializable> filter, Set<String> fulltext, DocumentModel context) {
        filter = filter != null ? this.cloneMap(filter) : new HashMap();
        HashSet<String> fulltextClone = fulltext != null ? this.cloneSet(fulltext) : new HashSet<String>();
        this.multiTenantManagement.queryTransformer(this, filter, fulltextClone, context);
        try (Session groupDir = this.dirService.open(this.groupDirectoryName, context);){
            this.removeVirtualFilters(filter);
            DocumentModelList documentModelList = groupDir.query(filter, fulltextClone, this.getGroupSortMap(), false);
            return documentModelList;
        }
    }

    @Override
    public DocumentModelList searchGroups(QueryBuilder queryBuilder, DocumentModel context) {
        queryBuilder = this.multiTenantManagement.groupQueryTransformer(this, queryBuilder, context);
        try (Session session = this.dirService.open(this.groupDirectoryName, context);){
            DocumentModelList documentModelList = session.query(queryBuilder, false);
            return documentModelList;
        }
    }

    @Override
    public DocumentModel createGroup(DocumentModel groupModel, DocumentModel context) throws GroupAlreadyExistsException {
        groupModel = this.multiTenantManagement.groupTransformer(this, groupModel, context);
        this.checkGrouId(groupModel);
        try (Session groupDir = this.dirService.open(this.groupDirectoryName, context);){
            String groupId = this.getGroupId(groupModel);
            if (groupDir.hasEntry(groupId)) {
                throw new GroupAlreadyExistsException();
            }
            groupModel = groupDir.createEntry(groupModel);
            this.notifyGroupChanged(groupId, GROUPCREATED_EVENT_ID);
            DocumentModel documentModel = groupModel;
            return documentModel;
        }
    }

    @Override
    public DocumentModel getGroupModel(String groupIdValue, DocumentModel context) {
        String groupName = this.multiTenantManagement.groupnameTranformer(this, groupIdValue, context);
        if (groupName != null) {
            groupName = groupName.trim();
        }
        try (Session groupDir = this.dirService.open(this.groupDirectoryName, context);){
            DocumentModel documentModel = groupDir.getEntry(groupName);
            return documentModel;
        }
    }

    @Override
    public DocumentModel getUserModel(String userName, DocumentModel context) {
        return this.getUserModel(userName, context, true);
    }

    protected DocumentModel getUserModel(String userName, DocumentModel context, boolean fetchReferences) {
        if (userName == null) {
            return null;
        }
        userName = userName.trim();
        if (this.anonymousUser != null && userName.equals(this.anonymousUser.getId())) {
            return this.makeVirtualUserEntry(this.getAnonymousUserId(), this.anonymousUser);
        }
        try (Session userDir = this.dirService.open(this.userDirectoryName, context);){
            DocumentModel userModel = userDir.getEntry(userName, fetchReferences);
            if (userModel != null && !fetchReferences) {
                userModel.putContextData(USER_HAS_PARTIAL_CONTENT, (Serializable)Boolean.valueOf(true));
            }
            DocumentModel documentModel = userModel;
            return documentModel;
        }
    }

    protected Map<String, Serializable> cloneMap(Map<String, Serializable> map) {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        for (String key : map.keySet()) {
            result.put(key, map.get(key));
        }
        return result;
    }

    protected HashSet<String> cloneSet(Set<String> set) {
        HashSet<String> result = new HashSet<String>();
        for (String key : set) {
            result.add(key);
        }
        return result;
    }

    @Override
    public NuxeoPrincipal getPrincipal(String username, DocumentModel context) {
        return this.getPrincipal(username, context, true);
    }

    protected NuxeoPrincipal getPrincipal(String username, DocumentModel context, boolean fetchReferences) {
        if (username == null) {
            return null;
        }
        String anonymousUserId = this.getAnonymousUserId();
        if (username.equals(anonymousUserId)) {
            return this.makeAnonymousPrincipal();
        }
        if (this.virtualUsers.containsKey(username)) {
            return this.makeVirtualPrincipal(this.virtualUsers.get(username));
        }
        if (NuxeoPrincipal.isTransientUsername((String)username)) {
            return this.makeTransientPrincipal(username);
        }
        DocumentModel userModel = this.getUserModel(username, context, fetchReferences);
        if (userModel != null) {
            return this.makePrincipal(userModel);
        }
        return null;
    }

    @Override
    public DocumentModelList searchGroups(String pattern, DocumentModel context) {
        QueryBuilder queryBuilder = this.getQueryForPattern(pattern, this.groupDirectoryName, this.groupSearchFields, this.getGroupOrderBy());
        return this.searchGroups(queryBuilder, context);
    }

    @Override
    public List<String> getUserIds(DocumentModel context) {
        try (Session userDir = this.dirService.open(this.userDirectoryName, context);){
            List userIds = userDir.getProjection(Collections.emptyMap(), userDir.getIdField());
            Collections.sort(userIds);
            List list = userIds;
            return list;
        }
    }

    @Override
    public DocumentModel createUser(DocumentModel userModel, DocumentModel context) throws UserAlreadyExistsException {
        this.checkUserId(userModel);
        try (Session userDir = this.dirService.open(this.userDirectoryName, context);){
            String userId = this.getUserId(userModel);
            if (userDir.hasEntry(userId)) {
                throw new UserAlreadyExistsException();
            }
            this.checkPasswordValidity(userModel);
            String schema = this.dirService.getDirectorySchema(this.userDirectoryName);
            this.checkGroupsExistence(userModel, schema, context);
            String clearUsername = (String)userModel.getProperty(schema, userDir.getIdField());
            String clearPassword = (String)userModel.getProperty(schema, userDir.getPasswordField());
            userModel = userDir.createEntry(userModel);
            this.syncDigestAuthPassword(clearUsername, clearPassword);
            this.notifyUserChanged(userId, USERCREATED_EVENT_ID);
            DocumentModel documentModel = userModel;
            return documentModel;
        }
    }

    protected void checkGroupsExistence(DocumentModel userModel, String schema, DocumentModel context) {
        List groups = (List)userModel.getProperty(schema, "groups");
        if (groups == null || groups.isEmpty()) {
            return;
        }
        try (Session groupDir = this.dirService.open(this.groupDirectoryName, context);){
            for (String group : groups) {
                if (groupDir.hasEntry(group)) continue;
                throw new NuxeoException("group does not exist: " + group, 403);
            }
        }
    }

    protected void checkPasswordValidity(DocumentModel userModel) throws InvalidPasswordException {
        String clearPassword;
        String passwordField;
        if (!this.mustCheckPasswordValidity()) {
            return;
        }
        String schema = this.dirService.getDirectorySchema(this.userDirectoryName);
        Property passwordProperty = userModel.getPropertyObject(schema, passwordField = this.dirService.getDirectory(this.userDirectoryName).getPasswordField());
        if (passwordProperty.isDirty() && StringUtils.isNotBlank((CharSequence)(clearPassword = (String)((Object)passwordProperty.getValue()))) && !this.validatePassword(clearPassword)) {
            throw new InvalidPasswordException();
        }
    }

    @Override
    public void updateUser(DocumentModel userModel, DocumentModel context) {
        try (Session userDir = this.dirService.open(this.userDirectoryName, context);){
            String userId = this.getUserId(userModel);
            if (!userDir.hasEntry(userId)) {
                throw new DirectoryException("user does not exist: " + userId);
            }
            String schema = this.dirService.getDirectorySchema(this.userDirectoryName);
            this.checkGroupsExistence(userModel, schema, context);
            this.checkPasswordValidity(userModel);
            String clearUsername = (String)userModel.getProperty(schema, userDir.getIdField());
            String clearPassword = (String)userModel.getProperty(schema, userDir.getPasswordField());
            userDir.updateEntry(userModel);
            this.syncDigestAuthPassword(clearUsername, clearPassword);
            this.notifyUserChanged(userId, USERMODIFIED_EVENT_ID);
        }
    }

    private boolean mustCheckPasswordValidity() {
        return ((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanTrue(VALIDATE_PASSWORD_PARAM);
    }

    protected boolean useSearchEscapeCompat() {
        return ((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanTrue(SEARCH_ESCAPE_COMPAT_PARAM);
    }

    @Override
    public void deleteUser(DocumentModel userModel, DocumentModel context) {
        String userId = this.getUserId(userModel);
        this.deleteUser(userId, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteUser(String userId, DocumentModel context) {
        try (Session userDir = this.dirService.open(this.userDirectoryName, context);){
            if (!userDir.hasEntry(userId)) {
                throw new DirectoryException("User does not exist: " + userId);
            }
            userDir.deleteEntry(userId);
            this.notifyUserChanged(userId, USERDELETED_EVENT_ID);
        }
        finally {
            this.notifyUserChanged(userId, null);
        }
    }

    @Override
    public void updateGroup(DocumentModel groupModel, DocumentModel context) {
        try (Session groupDir = this.dirService.open(this.groupDirectoryName, context);){
            String groupId = this.getGroupId(groupModel);
            if (!groupDir.hasEntry(groupId)) {
                throw new DirectoryException("group does not exist: " + groupId);
            }
            groupDir.updateEntry(groupModel);
            this.notifyGroupChanged(groupId, GROUPMODIFIED_EVENT_ID);
        }
    }

    @Override
    public void deleteGroup(DocumentModel groupModel, DocumentModel context) {
        String groupId = this.getGroupId(groupModel);
        this.deleteGroup(groupId, context);
    }

    @Override
    public void deleteGroup(String groupId, DocumentModel context) {
        try (Session groupDir = this.dirService.open(this.groupDirectoryName, context);){
            if (!groupDir.hasEntry(groupId)) {
                throw new DirectoryException("Group does not exist: " + groupId);
            }
            List<String> ancestorGroupNames = this.getAncestorGroups(groupId);
            groupDir.deleteEntry(groupId);
            this.notifyGroupChanged(groupId, GROUPDELETED_EVENT_ID, ancestorGroupNames);
        }
    }

    @Override
    public List<String> getGroupsInGroup(String parentId, DocumentModel context) {
        return this.getGroup(parentId, null).getMemberGroups();
    }

    @Override
    public List<String> getTopLevelGroups(DocumentModel context) {
        try (Session groupDir = this.dirService.open(this.groupDirectoryName, context);){
            LinkedList<String> topLevelGroups = new LinkedList<String>();
            DocumentModelList groups = groupDir.query(Collections.emptyMap(), null, null, true);
            for (DocumentModel group : groups) {
                List parents = (List)group.getProperty(this.groupSchemaName, this.groupParentGroupsField);
                if (parents != null && !parents.isEmpty()) continue;
                topLevelGroups.add(group.getId());
            }
            LinkedList<String> linkedList = topLevelGroups;
            return linkedList;
        }
    }

    @Override
    public List<String> getUsersInGroupAndSubGroups(String groupId, DocumentModel context) {
        HashSet<String> groups = new HashSet<String>();
        groups.add(groupId);
        this.appendSubgroups(groupId, groups, context);
        HashSet users = new HashSet();
        for (String groupid : groups) {
            users.addAll(this.getGroup(groupid, context).getMemberUsers());
        }
        return new ArrayList<String>(users);
    }

    @Override
    public String[] getUsersForPermission(String perm, ACP acp, DocumentModel context) {
        PermissionProvider permissionProvider = (PermissionProvider)Framework.getService(PermissionProvider.class);
        HashSet<String> usernames = new HashSet<String>();
        ACL merged = acp.getMergedACLs("merged");
        ArrayList<ACE> filteredACEbyPerm = new ArrayList<ACE>();
        List<String> currentPermissions = this.getLeafPermissions(perm);
        for (ACE ace : merged.getACEs()) {
            List<String> acePermissions = this.getLeafPermissions(ace.getPermission());
            if ("Everything".equals(ace.getPermission())) {
                acePermissions = Arrays.asList(permissionProvider.getPermissions());
            }
            if (!acePermissions.containsAll(currentPermissions)) continue;
            if ("Everyone".equals(ace.getUsername()) && !ace.isGranted()) break;
            filteredACEbyPerm.add(ace);
        }
        for (ACE ace : filteredACEbyPerm) {
            NuxeoGroup group;
            String aceUsername = ace.getUsername();
            List<String> users = null;
            if ("Everyone".equals(aceUsername)) {
                users = this.getUserIds();
            }
            if (users == null && (group = this.getGroup(aceUsername, context)) != null) {
                users = this.getUsersInGroupAndSubGroups(aceUsername, context);
            }
            if (users == null) {
                users = new ArrayList<String>();
                users.add(aceUsername);
            }
            if (ace.isGranted()) {
                usernames.addAll(users);
                continue;
            }
            usernames.removeAll(users);
        }
        return usernames.toArray(new String[usernames.size()]);
    }

    @Override
    public List<String> getAncestorGroups(String groupId) {
        ArrayList<String> ancestorGroups = new ArrayList<String>();
        this.populateAncestorGroups(groupId, ancestorGroups);
        return ancestorGroups;
    }

    protected void populateAncestorGroups(String groupId, List<String> ancestorGroups) {
        NuxeoGroup group = this.getGroup(groupId);
        if (group != null) {
            List parentGroups = group.getParentGroups();
            parentGroups.stream().filter(parentGroup -> !ancestorGroups.contains(parentGroup)).forEach(parentGroup -> {
                ancestorGroups.add((String)parentGroup);
                this.populateAncestorGroups((String)parentGroup, ancestorGroups);
            });
        }
    }

    @Override
    public List<String> getDescendantGroups(String groupId) {
        ArrayList<String> descendantGroups = new ArrayList<String>();
        this.populateDescendantGroups(groupId, descendantGroups);
        return descendantGroups;
    }

    protected void populateDescendantGroups(String groupId, List<String> descendantGroups) {
        NuxeoGroup group = this.getGroup(groupId);
        if (group != null) {
            List subGroups = group.getMemberGroups();
            subGroups.stream().filter(subGroup -> !descendantGroups.contains(subGroup)).forEach(subGroup -> {
                descendantGroups.add((String)subGroup);
                this.populateDescendantGroups((String)subGroup, descendantGroups);
            });
        }
    }

    @Override
    public GroupConfig getGroupConfig() {
        return this.groupConfig;
    }

    public void handleEvent(Event event) {
        String id = event.getId();
        if (INVALIDATE_PRINCIPAL_EVENT_ID.equals(id)) {
            this.invalidatePrincipal((String)event.getData());
        } else if (INVALIDATE_ALL_PRINCIPALS_EVENT_ID.equals(id)) {
            this.invalidateAllPrincipals();
        }
    }
}

