/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.security.AdministratorGroupsProvider;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.UserManagerDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.Authenticator;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.services.event.EventListener;
import org.nuxeo.runtime.services.event.EventService;

public class UserService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName(UserService.class.getName());
    protected static final String XP = "userManager";
    private UserManager userManager;

    public void start(ComponentContext context) {
        UserManagerDescriptor merged = (UserManagerDescriptor)this.getRegistryContribution(XP).orElseThrow(() -> new NuxeoException("No contributions registered for the userManager"));
        Class<?> klass = merged.userManagerClass;
        if (klass == null) {
            throw new NuxeoException("No class specified for the userManager");
        }
        try {
            this.userManager = (UserManager)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException((Throwable)e);
        }
        this.userManager.setConfiguration(merged);
        EventService eventService = (EventService)Framework.getService(EventService.class);
        eventService.addListener("usermanager", (EventListener)this.userManager);
    }

    public void stop(ComponentContext context) throws InterruptedException {
        EventService eventService;
        if (this.userManager != null && (eventService = (EventService)Framework.getService(EventService.class)) != null) {
            eventService.removeListener("usermanager", (EventListener)this.userManager);
        }
        this.userManager = null;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (Authenticator.class == adapter || UserManager.class == adapter || AdministratorGroupsProvider.class == adapter) {
            return adapter.cast(this.getUserManager());
        }
        return null;
    }
}

