/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectIterator
extends NiceIterator<Node> {
    final Iterator<?> domain;
    final Set<Node> seen = CollectionFactory.createHashedSet();
    final List<Node> pending = new ArrayList<Node>();

    public ObjectIterator(Iterator<?> domain) {
        this.domain = domain;
    }

    protected abstract Iterator<Triple> iteratorFor(Object var1);

    @Override
    public boolean hasNext() {
        while (this.pending.isEmpty() && this.domain.hasNext()) {
            this.refillPending();
        }
        return !this.pending.isEmpty();
    }

    @Override
    public Node next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("FasterTripleStore listObjects next()");
        }
        return this.pending.remove(this.pending.size() - 1);
    }

    protected void refillPending() {
        Object y = this.domain.next();
        if (y instanceof Node) {
            this.pending.add((Node)y);
        } else {
            Iterator<Triple> z = this.iteratorFor(y);
            while (z.hasNext()) {
                Node object = z.next().getObject();
                if (!this.seen.add(object)) continue;
                this.pending.add(object);
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("listObjects remove()");
    }
}

