/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jtajca;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import io.dropwizard.metrics5.Timer;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.BlankSpan;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.transaction.manager.NamedXAResourceFactory;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.apache.geronimo.transaction.manager.XidImpl;
import org.apache.xbean.naming.reference.SimpleReference;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.runtime.jtajca.InitialContextAccessor;
import org.nuxeo.runtime.jtajca.NamingContext;
import org.nuxeo.runtime.jtajca.NuxeoTransactionManagerFactory;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class NuxeoContainer {
    protected static final Log log = LogFactory.getLog(NuxeoContainer.class);
    protected static RecoverableTransactionManager tmRecoverable;
    protected static TransactionManager tm;
    protected static TransactionSynchronizationRegistry tmSynchRegistry;
    protected static UserTransaction ut;
    private static volatile InstallContext installContext;
    protected static Context rootContext;
    protected static Context parentContext;
    protected static String jndiPrefix;
    protected static final MetricRegistry registry;
    protected static final Counter rollbackCount;
    protected static final Counter concurrentCount;
    protected static final Counter concurrentMaxCount;
    protected static final Timer transactionTimer;
    protected static final ConcurrentHashMap<Transaction, Timer.Context> timers;

    private NuxeoContainer() {
    }

    protected static synchronized void install() throws NamingException {
        if (installContext != null) {
            throw new RuntimeException("Nuxeo container already installed");
        }
        installContext = new InstallContext();
        rootContext = new NamingContext();
        parentContext = InitialContextAccessor.getInitialContext();
        if (parentContext != null && parentContext != rootContext) {
            NuxeoContainer.installTransactionManager(parentContext);
        } else {
            NuxeoContainer.addDeepBinding(NuxeoContainer.nameOf("TransactionManager"), new Reference(TransactionManager.class.getName(), NuxeoTransactionManagerFactory.class.getName(), null));
            NuxeoContainer.installTransactionManager(rootContext);
        }
    }

    protected static void installTransactionManager(TransactionManagerConfiguration config) throws NamingException {
        NuxeoContainer.initTransactionManager(config);
        NuxeoContainer.addDeepBinding(rootContext, new CompositeName(NuxeoContainer.nameOf("TransactionManager")), NuxeoContainer.getTransactionManagerReference());
        NuxeoContainer.addDeepBinding(rootContext, new CompositeName(NuxeoContainer.nameOf("UserTransaction")), NuxeoContainer.getUserTransactionReference());
    }

    public static boolean isInstalled() {
        return installContext != null;
    }

    protected static void uninstall() throws NamingException {
        if (installContext == null) {
            throw new RuntimeException("Nuxeo container not installed");
        }
        log.trace((Object)"Uninstalling nuxeo container", (Throwable)installContext);
        installContext = null;
        rootContext = null;
        tm = null;
        tmRecoverable = null;
        tmSynchRegistry = null;
        ut = null;
    }

    protected static String detectJNDIPrefix(Context context) {
        String name = context.getClass().getName();
        if ("org.jnp.interfaces.NamingContext".equals(name)) {
            return "java:";
        }
        if ("org.jboss.as.naming.InitialContext".equals(name)) {
            return "java:jboss/";
        }
        if ("org.mortbay.naming.local.localContextRoot".equals(name)) {
            return "jdbc/";
        }
        return "java:comp/env/";
    }

    public static String nameOf(String name) {
        return jndiPrefix.concat(name);
    }

    public static Context getRootContext() {
        return rootContext;
    }

    public static void addDeepBinding(String name, Object obj) throws NamingException {
        NuxeoContainer.addDeepBinding(rootContext, new CompositeName(name), obj);
    }

    protected static void addDeepBinding(Context dir, CompositeName comp, Object obj) throws NamingException {
        Context subdir;
        Name name = comp.getPrefix(1);
        if (comp.size() == 1) {
            NuxeoContainer.addBinding(dir, name, obj);
            return;
        }
        try {
            subdir = (Context)dir.lookup(name);
        }
        catch (NamingException e) {
            subdir = dir.createSubcontext(name);
        }
        NuxeoContainer.addDeepBinding(subdir, (CompositeName)comp.getSuffix(1), obj);
    }

    protected static void addBinding(Context dir, Name name, Object obj) throws NamingException {
        try {
            dir.rebind(name, obj);
        }
        catch (NamingException e) {
            dir.bind(name, obj);
        }
    }

    protected static void removeBinding(String name) throws NamingException {
        rootContext.unbind(name);
    }

    public static TransactionManager getTransactionManager() {
        return tm;
    }

    protected static Reference getTransactionManagerReference() {
        return new SimpleReference(){
            private static final long serialVersionUID = 1L;

            public Object getContent() throws NamingException {
                return NuxeoContainer.getTransactionManager();
            }
        };
    }

    public static UserTransaction getUserTransaction() {
        return ut;
    }

    protected static Reference getUserTransactionReference() {
        return new SimpleReference(){
            private static final long serialVersionUID = 1L;

            public Object getContent() throws NamingException {
                return NuxeoContainer.getUserTransaction();
            }
        };
    }

    protected static synchronized TransactionManager initTransactionManager(TransactionManagerConfiguration config) {
        TransactionManagerImpl impl = NuxeoContainer.createTransactionManager(config);
        tm = impl;
        tmRecoverable = impl;
        tmSynchRegistry = impl;
        ut = new UserTransactionImpl(tm);
        return tm;
    }

    protected static TransactionManagerWrapper wrapTransactionManager(TransactionManager tm) {
        if (tm == null) {
            return null;
        }
        if (tm instanceof TransactionManagerWrapper) {
            return (TransactionManagerWrapper)tm;
        }
        return new TransactionManagerWrapper(tm);
    }

    public static <T> T lookup(String name, Class<T> type) throws NamingException {
        if (rootContext == null) {
            throw new NamingException("no naming context available");
        }
        return NuxeoContainer.lookup(rootContext, name, type);
    }

    public static <T> T lookup(Context context, String name, Class<T> type) throws NamingException {
        Object resolved;
        try {
            resolved = context.lookup(NuxeoContainer.detectJNDIPrefix(context).concat(name));
        }
        catch (NamingException cause) {
            if (parentContext == null) {
                throw cause;
            }
            return type.cast(parentContext.lookup(NuxeoContainer.detectJNDIPrefix(parentContext).concat(name)));
        }
        if (resolved instanceof Reference) {
            try {
                resolved = NamingManager.getObjectInstance(resolved, new CompositeName(name), rootContext, null);
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                throw ExceptionUtils.runtimeException((Exception)e);
            }
        }
        return type.cast(resolved);
    }

    protected static void installTransactionManager(Context context) throws NamingException {
        TransactionManager actual = NuxeoContainer.lookup(context, "TransactionManager", TransactionManager.class);
        if (tm != null) {
            return;
        }
        tm = actual;
        tmRecoverable = NuxeoContainer.wrapTransactionManager(tm);
        ut = new UserTransactionImpl(tm);
        tmSynchRegistry = (TransactionSynchronizationRegistry)tm;
    }

    protected static TransactionManagerImpl createTransactionManager(TransactionManagerConfiguration config) {
        if (config == null) {
            config = new TransactionManagerConfiguration();
        }
        try {
            return new TransactionManagerImpl(config.transactionTimeoutSeconds);
        }
        catch (XAException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    public static TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return tmSynchRegistry;
    }

    static {
        jndiPrefix = "java:comp/env/";
        registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
        rollbackCount = registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"transactions", "rollbacks"}));
        concurrentCount = registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"transactions", "concurrency"}));
        concurrentMaxCount = registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"transactions", "concurrency", "max"}));
        transactionTimer = registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"transactions", "timer"}));
        timers = new ConcurrentHashMap();
    }

    public static class TransactionManagerWrapper
    implements RecoverableTransactionManager {
        protected TransactionManager tm;

        public TransactionManagerWrapper(TransactionManager tm) {
            this.tm = tm;
        }

        public Transaction suspend() throws SystemException {
            return this.tm.suspend();
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
            this.tm.setTransactionTimeout(seconds);
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.tm.setRollbackOnly();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            this.tm.rollback();
        }

        public void resume(Transaction tobj) throws IllegalStateException, InvalidTransactionException, SystemException {
            this.tm.resume(tobj);
        }

        public int getStatus() throws SystemException {
            return this.tm.getStatus();
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            this.tm.commit();
        }

        public void begin() throws SystemException {
            try {
                this.tm.begin();
            }
            catch (NotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public void recoveryError(Exception e) {
            throw new UnsupportedOperationException();
        }

        public void registerNamedXAResourceFactory(NamedXAResourceFactory factory) {
            if (!RecoverableTransactionManager.class.isAssignableFrom(this.tm.getClass())) {
                throw new UnsupportedOperationException();
            }
            ((RecoverableTransactionManager)this.tm).registerNamedXAResourceFactory(factory);
        }

        public void unregisterNamedXAResourceFactory(String factory) {
            if (!RecoverableTransactionManager.class.isAssignableFrom(this.tm.getClass())) {
                throw new UnsupportedOperationException();
            }
            ((RecoverableTransactionManager)this.tm).unregisterNamedXAResourceFactory(factory);
        }

        public Transaction getTransaction() throws SystemException {
            final Transaction tx = this.tm.getTransaction();
            if (tx instanceof TransactionImpl) {
                return tx;
            }
            return new TransactionImpl(null, null){

                public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
                    tx.commit();
                }

                public void rollback() throws IllegalStateException, SystemException {
                    tx.rollback();
                }

                public synchronized boolean enlistResource(XAResource xaRes) throws IllegalStateException, RollbackException, SystemException {
                    return tx.enlistResource(xaRes);
                }

                public synchronized boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
                    return super.delistResource(xaRes, flag);
                }

                public synchronized void setRollbackOnly() throws IllegalStateException {
                    try {
                        tx.setRollbackOnly();
                    }
                    catch (SystemException e) {
                        throw new IllegalStateException(e);
                    }
                }

                public void registerInterposedSynchronization(Synchronization synchronization) {
                    try {
                        TransactionHelper.lookupSynchronizationRegistry().registerInterposedSynchronization(synchronization);
                    }
                    catch (NamingException namingException) {
                        // empty catch block
                    }
                }
            };
        }
    }

    public static class TransactionManagerConfiguration {
        public int transactionTimeoutSeconds = 600;

        public void setTransactionTimeoutSeconds(int transactionTimeoutSeconds) {
            this.transactionTimeoutSeconds = transactionTimeoutSeconds;
        }
    }

    public static class UserTransactionImpl
    implements UserTransaction {
        protected final TransactionManager transactionManager;

        public UserTransactionImpl(TransactionManager manager) {
            this.transactionManager = manager;
        }

        public int getStatus() throws SystemException {
            return this.transactionManager.getStatus();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.transactionManager.setRollbackOnly();
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
            this.transactionManager.setTransactionTimeout(seconds);
        }

        public void begin() throws NotSupportedException, SystemException {
            this.transactionManager.begin();
            Tracer tracer = Tracing.getTracer();
            Span span = tracer.getCurrentSpan();
            if (!(span instanceof BlankSpan)) {
                HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
                map.put("tx.thread", AttributeValue.stringAttributeValue((String)Thread.currentThread().getName()));
                map.put("tx.id", AttributeValue.stringAttributeValue((String)this.getTransactionId()));
                span.addAnnotation("tx.begin", map);
            }
            timers.put(this.transactionManager.getTransaction(), transactionTimer.time());
            concurrentCount.inc();
            if (concurrentCount.getCount() > concurrentMaxCount.getCount()) {
                concurrentMaxCount.inc();
            }
        }

        protected String getTransactionId() {
            return UserTransactionImpl.transactionKeyAsString(((TransactionManagerImpl)this.transactionManager).getTransactionKey());
        }

        protected static String transactionKeyAsString(Object key) {
            if (key instanceof XidImpl) {
                byte[] globalId = ((XidImpl)key).getGlobalTransactionId();
                StringBuilder buffer = new StringBuilder();
                for (byte aGlobalId : globalId) {
                    buffer.append(Integer.toHexString(aGlobalId));
                }
                String stringKey = buffer.toString();
                for (int index = stringKey.length() - 1; index >= 0; --index) {
                    if (stringKey.charAt(index) == '0') continue;
                    return stringKey.substring(0, index + 1);
                }
                return stringKey;
            }
            return key.toString();
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            Span span = Tracing.getTracer().getCurrentSpan();
            span.addAnnotation("tx.committing");
            Transaction transaction = this.transactionManager.getTransaction();
            if (transaction == null) {
                throw new IllegalStateException("No transaction associated with current thread");
            }
            Timer.Context timerContext = timers.remove(transaction);
            this.transactionManager.commit();
            if (timerContext != null) {
                long elapsed = timerContext.stop();
                HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
                map.put("tx.duration_ms", AttributeValue.longAttributeValue((long)(elapsed / 1000000L)));
                span.addAnnotation("tx.commited", map);
            }
            concurrentCount.dec();
            span.setStatus(Status.OK);
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            Span span = Tracing.getTracer().getCurrentSpan();
            span.addAnnotation("tx.rollbacking");
            Transaction transaction = this.transactionManager.getTransaction();
            if (transaction == null) {
                throw new IllegalStateException("No transaction associated with current thread");
            }
            Timer.Context timerContext = timers.remove(transaction);
            this.transactionManager.rollback();
            concurrentCount.dec();
            rollbackCount.inc();
            if (timerContext != null) {
                long elapsed = timerContext.stop();
                span.addAnnotation("tx.rollbacked " + elapsed / 1000000L + "ms");
            } else {
                span.addAnnotation("tx.rollbacked");
            }
            span.setStatus(Status.UNKNOWN);
        }
    }

    public static class InstallContext
    extends Throwable {
        private static final long serialVersionUID = 1L;
        public final String threadName = Thread.currentThread().getName();

        InstallContext() {
            super("Container installation context (" + Thread.currentThread().getName() + ")");
        }
    }
}

