/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.http.servlet;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.MustBeClosed;
import io.opencensus.common.Scope;
import io.opencensus.contrib.http.HttpRequestContext;
import io.opencensus.contrib.http.HttpServerHandler;
import io.opencensus.contrib.http.servlet.OcHttpServletUtil;
import io.opencensus.trace.Tracing;
import java.io.Closeable;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class OcHttpServletListener
implements Closeable,
AsyncListener {
    private final HttpRequestContext context;
    private final HttpServerHandler<HttpServletRequest, HttpServletResponse, HttpServletRequest> handler;

    OcHttpServletListener(HttpServerHandler<HttpServletRequest, HttpServletResponse, HttpServletRequest> handler, HttpRequestContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context");
        Preconditions.checkNotNull(handler, (Object)"handler");
        this.context = context;
        this.handler = handler;
    }

    @Override
    public void close() {
    }

    public void onComplete(AsyncEvent event) {
        ServletResponse response = event.getSuppliedResponse();
        if (response instanceof HttpServletResponse) {
            OcHttpServletUtil.recordMessageSentEvent(this.handler, this.context, (HttpServletResponse)response);
        }
        this.handler.handleEnd(this.context, (Object)((HttpServletRequest)event.getSuppliedRequest()), (Object)((HttpServletResponse)event.getSuppliedResponse()), null);
        this.close();
    }

    public void onError(AsyncEvent event) {
        this.handler.handleEnd(this.context, (Object)((HttpServletRequest)event.getSuppliedRequest()), (Object)((HttpServletResponse)event.getSuppliedResponse()), event.getThrowable());
    }

    public void onStartAsync(AsyncEvent event) {
        AsyncContext eventAsyncContext = event.getAsyncContext();
        if (eventAsyncContext != null) {
            eventAsyncContext.addListener((AsyncListener)this, event.getSuppliedRequest(), event.getSuppliedResponse());
        }
    }

    public void onTimeout(AsyncEvent event) {
        this.handler.handleEnd(this.context, (Object)((HttpServletRequest)event.getSuppliedRequest()), (Object)((HttpServletResponse)event.getSuppliedResponse()), null);
    }

    @MustBeClosed
    Scope withSpan() {
        return Tracing.getTracer().withSpan(this.handler.getSpanFromContext(this.context));
    }
}

