/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.http.servlet;

import com.google.common.base.Preconditions;
import io.grpc.Context;
import java.io.IOException;
import javax.servlet.WriteListener;

public class WriteListenerWrapper
implements WriteListener {
    private final Context context;
    private final WriteListener writeListener;

    public WriteListenerWrapper(WriteListener writeListener) {
        Preconditions.checkNotNull((Object)writeListener, (Object)"WriteListener is null");
        this.context = Context.current();
        this.writeListener = writeListener;
    }

    public void onWritePossible() throws IOException {
        Context previousContext = this.context.attach();
        try {
            this.writeListener.onWritePossible();
        }
        finally {
            this.context.detach(previousContext);
        }
    }

    public void onError(Throwable t) {
        this.writeListener.onError(t);
    }
}

