/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.jaxrs.io.management;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.List;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.runtime.migration.Migration;
import org.nuxeo.runtime.migration.MigrationService;
import org.nuxeo.runtime.migration.MigrationStep;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class MigrationJsonWriter
extends ExtensibleEntityJsonWriter<Migration> {
    public static final String ENTITY_TYPE = "migration";

    public MigrationJsonWriter() {
        super(ENTITY_TYPE, Migration.class);
    }

    public void writeEntityBody(Migration entity, JsonGenerator jg) throws IOException {
        jg.writeStringField("id", entity.getId());
        jg.writeStringField("description", entity.getDescription());
        jg.writeStringField("descriptionLabel", entity.getDescriptionLabel());
        this.writeMigrationStatus(entity.getStatus(), jg);
        this.writeMigrationSteps(entity.getSteps(), jg);
    }

    protected void writeMigrationStatus(MigrationService.MigrationStatus status, JsonGenerator jg) throws IOException {
        jg.writeObjectFieldStart("status");
        jg.writeStringField("state", status.getState());
        jg.writeStringField("step", status.getStep());
        jg.writeNumberField("startTime", status.getStartTime());
        jg.writeNumberField("pingTime", status.getPingTime());
        jg.writeStringField("progressMessage", status.getProgressMessage());
        jg.writeNumberField("progressNum", status.getProgressNum());
        jg.writeNumberField("progressTotal", status.getProgressTotal());
        jg.writeBooleanField("running", status.isRunning());
        jg.writeEndObject();
    }

    protected void writeMigrationSteps(List<MigrationStep> steps, JsonGenerator jg) throws IOException {
        jg.writeArrayFieldStart("steps");
        for (MigrationStep step : steps) {
            jg.writeStartObject();
            jg.writeStringField("id", step.getId());
            jg.writeStringField("fromState", step.getFromState());
            jg.writeStringField("toState", step.getToState());
            jg.writeStringField("description", step.getDescription());
            jg.writeStringField("descriptionLabel", step.getDescriptionLabel());
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }
}

