/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.jaxrs.io.management;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Date;
import org.nuxeo.common.utils.DateUtils;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.management.api.ProbeInfo;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class ProbeInfoJsonWriter
extends ExtensibleEntityJsonWriter<ProbeInfo> {
    public static final String ENTITY_TYPE = "probe";

    public ProbeInfoJsonWriter() {
        super(ENTITY_TYPE, ProbeInfo.class);
    }

    protected void writeEntityBody(ProbeInfo entity, JsonGenerator jg) throws IOException {
        jg.writeStringField("name", entity.getShortcutName());
        this.writeEntityField("status", entity.getStatus(), jg);
        jg.writeObjectFieldStart("history");
        jg.writeStringField("lastRun", DateUtils.formatISODateTime((Date)entity.getLastRunnedDate()));
        jg.writeStringField("lastSuccess", DateUtils.formatISODateTime((Date)entity.getLastSucceedDate()));
        jg.writeStringField("lastFail", DateUtils.formatISODateTime((Date)entity.getLastFailedDate()));
        jg.writeEndObject();
        jg.writeObjectFieldStart("counts");
        jg.writeNumberField("run", entity.getRunnedCount());
        jg.writeNumberField("success", entity.getSucceedCount());
        jg.writeNumberField("failure", entity.getFailedCount());
        jg.writeEndObject();
        jg.writeNumberField("time", entity.getLastDuration());
    }
}

