/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.gui;

import java.awt.Dimension;
import java.awt.Toolkit;
import javax.naming.NamingException;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.SearchEngine;
import org.apache.directory.server.core.partition.impl.btree.gui.PartitionFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionViewer {
    private static final Logger log = LoggerFactory.getLogger(PartitionViewer.class);
    private BTreePartition partition;
    private SearchEngine eng;

    public PartitionViewer(BTreePartition db, SearchEngine eng) {
        this.partition = db;
        this.eng = eng;
    }

    public int execute() throws NamingException {
        PartitionFrame frame = new PartitionFrame(this.partition, this.eng);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        frameSize.height = frameSize.height > screenSize.height ? screenSize.height : frameSize.height;
        frameSize.width = frameSize.width > screenSize.width ? screenSize.width : frameSize.width;
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
        log.debug(frameSize + "");
        return 0;
    }
}

