/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.lifecycle.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.common.xmap.registry.MapRegistry;

public class LifeCycleTypeRegistry
extends MapRegistry {
    protected Map<String, String> typesMapping = new ConcurrentHashMap<String, String>();
    protected Map<String, List<String>> docTypeToNonRecursiveTransition = new ConcurrentHashMap<String, List<String>>();

    public void initialize() {
        this.typesMapping.clear();
        this.docTypeToNonRecursiveTransition.clear();
        super.initialize();
        this.getContributionValues().forEach(contrib -> {
            this.typesMapping.put(contrib.getDocumentType(), contrib.getLifeCycleName());
            String transitionArray = contrib.getNoRecursionForTransitions();
            List<Object> transitions = new ArrayList();
            if (transitionArray != null && !transitionArray.isEmpty()) {
                transitions = Arrays.asList(contrib.getNoRecursionForTransitions().split(","));
            }
            this.docTypeToNonRecursiveTransition.put(contrib.getDocumentType(), transitions);
        });
    }

    public String getLifeCycleNameForType(String docType) {
        this.checkInitialized();
        return this.typesMapping.get(docType);
    }

    public Collection<String> getTypesFor(String lifeCycleName) {
        this.checkInitialized();
        ArrayList<String> types = new ArrayList<String>();
        for (String typeName : this.typesMapping.keySet()) {
            if (!this.typesMapping.get(typeName).equals(lifeCycleName)) continue;
            types.add(typeName);
        }
        return types;
    }

    public Map<String, String> getTypesMapping() {
        this.checkInitialized();
        return Collections.unmodifiableMap(this.typesMapping);
    }

    public List<String> getNonRecursiveTransitionForDocType(String docTypeName) {
        this.checkInitialized();
        return this.docTypeToNonRecursiveTransition.get(docTypeName);
    }
}

