/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.ecm.core.api.security.UserVisiblePermission;
import org.nuxeo.ecm.core.security.PermissionUIItemDescriptor;

@XObject(value="visibility")
@XRegistry
public class PermissionVisibilityDescriptor {
    public static final Comparator<PermissionUIItemDescriptor> ITEM_COMPARATOR = Comparator.comparing(PermissionUIItemDescriptor::getOrder).thenComparing(PermissionUIItemDescriptor::getPermission);
    @XNode(value="@type", defaultAssignment="")
    @XRegistryId
    private String typeName = "";
    @XNodeList(value="item", type=ArrayList.class, componentType=PermissionUIItemDescriptor.class)
    private List<PermissionUIItemDescriptor> items = new ArrayList<PermissionUIItemDescriptor>();

    public PermissionVisibilityDescriptor() {
    }

    public PermissionVisibilityDescriptor(PermissionVisibilityDescriptor pvd) {
        this.typeName = pvd.typeName;
        for (PermissionUIItemDescriptor pid : pvd.items) {
            this.items.add(new PermissionUIItemDescriptor(pid));
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public List<PermissionUIItemDescriptor> getPermissionUIItems() {
        return Collections.unmodifiableList(this.items);
    }

    public void merge(PermissionVisibilityDescriptor other) {
        ArrayList<PermissionUIItemDescriptor> otherItems = new ArrayList<PermissionUIItemDescriptor>(other.items);
        LinkedList<PermissionUIItemDescriptor> mergedItems = new LinkedList<PermissionUIItemDescriptor>();
        for (PermissionUIItemDescriptor item : this.items) {
            for (PermissionUIItemDescriptor otherItem : otherItems) {
                if (!item.getPermission().equals(otherItem.getPermission())) continue;
                item.merge(otherItem);
                mergedItems.add(otherItem);
            }
            otherItems.removeAll(mergedItems);
            mergedItems.clear();
        }
        this.items.addAll(otherItems);
    }

    public String[] getSortedItems() {
        return (String[])this.items.stream().filter(PermissionUIItemDescriptor::isShown).sorted(ITEM_COMPARATOR).map(PermissionUIItemDescriptor::getPermission).toArray(String[]::new);
    }

    public List<UserVisiblePermission> getSortedUIPermissionDescriptor() {
        return this.items.stream().filter(PermissionUIItemDescriptor::isShown).sorted(ITEM_COMPARATOR).map(pid -> new UserVisiblePermission(pid.getPermission(), pid.getDenyPermission())).collect(Collectors.toList());
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    public String toString() {
        return String.format("PermissionVisibilityDescriptor[%s]", this.typeName);
    }
}

