/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.util.Arrays;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.security.AbstractSecurityPolicy;

public class RetentionAndHoldSecurityPolicy
extends AbstractSecurityPolicy {
    @Override
    public Access checkPermission(Document doc, ACP mergedAcp, NuxeoPrincipal principal, String permission, String[] resolvedPermissions, String[] additionalPrincipals) {
        if (!Arrays.asList(resolvedPermissions).contains("Remove")) {
            return Access.UNKNOWN;
        }
        if (!doc.isUnderRetentionOrLegalHold()) {
            return Access.UNKNOWN;
        }
        return Access.DENY;
    }

    @Override
    public boolean isRestrictingPermission(String permission) {
        return permission.equals("Remove");
    }

    @Override
    public boolean isExpressibleInQuery(String repositoryName) {
        return true;
    }

    @Override
    public SQLQuery.Transformer getQueryTransformer(String repositoryName) {
        return SQLQuery.Transformer.IDENTITY;
    }
}

