/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.security.SecurityPolicy;
import org.nuxeo.ecm.core.security.SecurityPolicyDescriptor;
import org.nuxeo.ecm.core.security.SecurityPolicyService;

public class SecurityPolicyServiceImpl
implements SecurityPolicyService {
    private static final Logger log = LogManager.getLogger(SecurityPolicyServiceImpl.class);
    private final List<SecurityPolicy> policies = new ArrayList<SecurityPolicy>();

    public SecurityPolicyServiceImpl(List<SecurityPolicyDescriptor> policyDescriptors) {
        ArrayList<SecurityPolicyDescriptor> orderedDescriptors = new ArrayList<SecurityPolicyDescriptor>(policyDescriptors);
        Collections.sort(orderedDescriptors);
        ArrayList<String> policyNames = new ArrayList<String>();
        for (SecurityPolicyDescriptor descriptor : orderedDescriptors) {
            try {
                Object policy = descriptor.getPolicy().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (policy instanceof SecurityPolicy) {
                    this.policies.add((SecurityPolicy)policy);
                    policyNames.add(descriptor.getName());
                    continue;
                }
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = descriptor::getName;
                supplierArray[1] = descriptor::getPolicy;
                log.error("Invalid contribution to security policy service {}: class {} must implement the SecurityPolicy interface", supplierArray);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        log.debug("Ordered security policies: {}", policyNames);
    }

    @Override
    public List<SecurityPolicy> getPolicies() {
        return Collections.unmodifiableList(this.policies);
    }

    @Override
    public boolean arePoliciesRestrictingPermission(String permission) {
        for (SecurityPolicy policy : this.getPolicies()) {
            if (!policy.isRestrictingPermission(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean arePoliciesExpressibleInQuery(String repositoryName) {
        for (SecurityPolicy policy : this.getPolicies()) {
            if (policy.isExpressibleInQuery(repositoryName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<SQLQuery.Transformer> getPoliciesQueryTransformers(String repositoryName) {
        LinkedList<SQLQuery.Transformer> transformers = new LinkedList<SQLQuery.Transformer>();
        for (SecurityPolicy policy : this.getPolicies()) {
            if (policy.isExpressibleInQuery(repositoryName)) {
                transformers.add(policy.getQueryTransformer(repositoryName));
                continue;
            }
            log.warn("Security policy '{}' for repository '{}' cannot be expressed in SQL query.", (Object)policy.getClass().getName(), (Object)repositoryName);
        }
        return transformers;
    }

    @Override
    public Access checkPermission(Document doc, ACP mergedAcp, NuxeoPrincipal principal, String permission, String[] resolvedPermissions, String[] additionalPrincipals) {
        Access access = Access.UNKNOWN;
        for (SecurityPolicy policy : this.getPolicies()) {
            Access policyAccess = policy.checkPermission(doc, mergedAcp, principal, permission, resolvedPermissions, additionalPrincipals);
            if (policyAccess == null || Access.UNKNOWN.equals(policyAccess)) continue;
            access = policyAccess;
            break;
        }
        return access;
    }
}

