/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionRuntimeException;

public class UpdateACEStatusWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_BATCH_SIZE = 20;
    public static final String CATEGORY = "updateACEStatus";
    public static final String QUERY = "SELECT ecm:uuid, ecm:acl/*1/principal, ecm:acl/*1/permission, ecm:acl/*1/grant, ecm:acl/*1/creator, ecm:acl/*1/begin, ecm:acl/*1/end, ecm:acl/*1/name FROM Document WHERE (ecm:acl/*1/status = 0 AND ecm:acl/*1/begin <= TIMESTAMP '%s') OR (ecm:acl/*1/status = 1 AND ecm:acl/*1/end <= TIMESTAMP '%s')";
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    protected int batchSize = 20;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void work() {
        this.setStatus("Updating ACE status");
        this.openSystemSession();
        String formattedDate = FORMATTER.format(ZonedDateTime.now());
        HashMap docIdsToACEs = new HashMap();
        try (IterableQueryResult result = this.session.queryAndFetch(String.format(QUERY, formattedDate, formattedDate), "NXQL", new Object[0]);){
            for (Map map : result) {
                String docId = (String)map.get("ecm:uuid");
                ArrayList<ACE> aces = (ArrayList<ACE>)docIdsToACEs.get(docId);
                if (aces == null) {
                    aces = new ArrayList<ACE>();
                    docIdsToACEs.put(docId, aces);
                }
                String username = (String)map.get("ecm:acl/*1/principal");
                String permission = (String)map.get("ecm:acl/*1/permission");
                Boolean grant = (Boolean)map.get("ecm:acl/*1/grant");
                String creator = (String)map.get("ecm:acl/*1/creator");
                Calendar begin = (Calendar)map.get("ecm:acl/*1/begin");
                Calendar end = (Calendar)map.get("ecm:acl/*1/end");
                String aclName = (String)map.get("ecm:acl/*1/name");
                HashMap<String, String> contextData = new HashMap<String, String>();
                contextData.put("changedACLName", aclName);
                ACE ace = ACE.builder((String)username, (String)permission).isGranted(grant.booleanValue()).creator(creator).begin(begin).end(end).contextData(contextData).build();
                aces.add(ace);
            }
        }
        int acpUpdatedCount = 0;
        HashMap<DocumentRef, List<ACE>> processedRefToACEs = new HashMap<DocumentRef, List<ACE>>();
        for (Map.Entry entry : docIdsToACEs.entrySet()) {
            try {
                IdRef ref = new IdRef((String)entry.getKey());
                ACP acp = this.session.getACP((DocumentRef)ref);
                this.session.setACP((DocumentRef)ref, acp, true);
                processedRefToACEs.put((DocumentRef)ref, (List)entry.getValue());
                if (++acpUpdatedCount % this.batchSize != 0) continue;
                this.fireACEStatusUpdatedEvent(processedRefToACEs);
                this.commitOrRollbackTransaction();
                this.startTransaction();
                processedRefToACEs.clear();
            }
            catch (TransactionRuntimeException e) {
                if (e.getMessage().contains("Transaction timeout")) {
                    this.batchSize = 1;
                }
                throw e;
            }
        }
        this.fireACEStatusUpdatedEvent(processedRefToACEs);
        this.setStatus(null);
    }

    protected void fireACEStatusUpdatedEvent(Map<DocumentRef, List<ACE>> refToACEs) {
        EventContextImpl eventContext = new EventContextImpl(this.session, this.session.getPrincipal());
        eventContext.setProperty("documentRefs", (Serializable)((Object)refToACEs));
        eventContext.setProperty("repositoryName", (Serializable)((Object)this.session.getRepositoryName()));
        ((EventService)Framework.getService(EventService.class)).fireEvent("ACEStatusUpdated", (EventContext)eventContext);
    }

    public String getCategory() {
        return CATEGORY;
    }

    public String getTitle() {
        return "Updating ACE status";
    }

    public int getRetryCount() {
        return 10;
    }
}

