/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.uidgen;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.uidgen.UIDGenerator;
import org.nuxeo.ecm.core.uidgen.UIDGeneratorDescriptor;
import org.nuxeo.ecm.core.uidgen.UIDGeneratorService;
import org.nuxeo.ecm.core.uidgen.UIDSequencer;
import org.nuxeo.ecm.core.uidgen.UIDSequencerProviderDescriptor;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class UIDGeneratorComponent
extends DefaultComponent
implements UIDGeneratorService {
    private static final Logger log = LogManager.getLogger(UIDGeneratorComponent.class);
    public static final String ID = "org.nuxeo.ecm.core.uidgen.UIDGeneratorService";
    public static final String UID_GENERATORS_EXTENSION_POINT = "generators";
    public static final String SEQUENCERS_EXTENSION_POINT = "sequencers";
    protected Map<String, UIDGenerator> generators;
    protected Map<String, UIDSequencer> sequencers;
    protected String defaultSequencer;

    public void start(ComponentContext context) {
        this.initGenerators();
        this.initSequencers();
    }

    protected void initGenerators() {
        this.generators = new HashMap<String, UIDGenerator>();
        List contribs = this.getRegistryContributions(UID_GENERATORS_EXTENSION_POINT);
        for (UIDGeneratorDescriptor generatorDescriptor : contribs) {
            String[] docTypes;
            String msg;
            UIDGenerator generator;
            String generatorName = generatorDescriptor.getName();
            try {
                generator = generatorDescriptor.getGenerator();
            }
            catch (ReflectiveOperationException e) {
                msg = String.format("Failed to create UIDGenerator with name '%s': %s", this.name, e.getMessage());
                log.error(msg, (Throwable)e);
                this.addRuntimeMessage(RuntimeMessage.Level.ERROR, msg);
                continue;
            }
            String[] propNames = generatorDescriptor.getPropertyNames();
            if (propNames.length == 0) {
                msg = String.format("No property name defined on generator '%s'", generatorName);
                log.error(msg);
                this.addRuntimeMessage(RuntimeMessage.Level.ERROR, msg);
                continue;
            }
            generator.setPropertyNames(propNames);
            for (String docType : docTypes = generatorDescriptor.getDocTypes()) {
                UIDGenerator previous = this.generators.put(docType, generator);
                if (previous != null) {
                    log.info("Overwriting generator: {} for docType: {}", previous.getClass(), (Object)docType);
                }
                log.info("Registered generator: {}  for docType: {}", generator.getClass(), (Object)docType);
            }
        }
    }

    protected void initSequencers() {
        this.sequencers = new HashMap<String, UIDSequencer>();
        List seqs = this.getRegistryContributions(SEQUENCERS_EXTENSION_POINT);
        String def = null;
        String last = null;
        for (UIDSequencerProviderDescriptor contrib : seqs) {
            UIDSequencer seq;
            String name = contrib.getName();
            try {
                seq = contrib.getSequencer();
            }
            catch (ReflectiveOperationException e) {
                String msg = String.format("Failed to create UIDSequencer with name '%s': %s", name, e.getMessage());
                log.error(msg, (Throwable)e);
                this.addRuntimeMessage(RuntimeMessage.Level.ERROR, msg);
                continue;
            }
            seq.setName(name);
            seq.init();
            this.sequencers.put(name, seq);
            if (contrib.isDefault()) {
                def = name;
            }
            last = name;
        }
        if (def == null) {
            def = last;
        }
        this.defaultSequencer = def;
    }

    public void stop(ComponentContext context) {
        this.generators = null;
        this.sequencers.values().forEach(UIDSequencer::dispose);
        this.sequencers = null;
        this.defaultSequencer = null;
    }

    @Override
    public UIDGenerator getUIDGeneratorFor(DocumentModel doc) {
        String docTypeName = doc.getType();
        UIDGenerator generator = this.generators.get(docTypeName);
        if (generator == null) {
            log.debug("No UID Generator defined for doc type: {}", (Object)docTypeName);
            return null;
        }
        generator.setSequencer((UIDSequencer)Framework.getService(UIDSequencer.class));
        return generator;
    }

    @Override
    public void setUID(DocumentModel doc) throws PropertyNotFoundException {
        UIDGenerator generator = this.getUIDGeneratorFor(doc);
        if (generator != null) {
            generator.setUID(doc);
        }
    }

    @Override
    public String createUID(DocumentModel doc) {
        UIDGenerator generator = this.getUIDGeneratorFor(doc);
        if (generator == null) {
            return null;
        }
        return generator.createUID(doc);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (UIDSequencer.class.isAssignableFrom(adapter)) {
            return adapter.cast(this.getSequencer());
        }
        if (UIDGeneratorService.class.isAssignableFrom(adapter)) {
            return adapter.cast(this);
        }
        return null;
    }

    @Override
    public UIDSequencer getSequencer() {
        return this.getSequencer(null);
    }

    @Override
    public UIDSequencer getSequencer(String name) {
        if (name == null) {
            name = this.defaultSequencer;
        }
        return this.sequencers.get(name);
    }
}

