/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.versioning;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.versioning.DefaultVersioningRuleDescriptor;
import org.nuxeo.ecm.core.versioning.ExtendableVersioningService;
import org.nuxeo.ecm.core.versioning.StandardVersioningService;
import org.nuxeo.ecm.core.versioning.VersioningFilterDescriptor;
import org.nuxeo.ecm.core.versioning.VersioningPolicyDescriptor;
import org.nuxeo.ecm.core.versioning.VersioningRestrictionDescriptor;
import org.nuxeo.ecm.core.versioning.VersioningRuleDescriptor;
import org.nuxeo.ecm.core.versioning.VersioningService;
import org.nuxeo.ecm.core.versioning.VersioningServiceDescriptor;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.logging.DeprecationLogger;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class VersioningComponent
extends DefaultComponent
implements VersioningService {
    private static final Log log = LogFactory.getLog(VersioningComponent.class);
    public static final String VERSIONING_SERVICE_XP = "versioningService";
    public static final String VERSIONING_RULE_XP = "versioningRules";
    public static final String VERSIONING_POLICY_XP = "policies";
    public static final String VERSIONING_FILTER_XP = "filters";
    public static final String VERSIONING_RESTRICTION_XP = "restrictions";
    protected static final StandardVersioningService STANDARD_VERSIONING_SERVICE = new StandardVersioningService();
    protected Map<VersioningServiceDescriptor, VersioningService> versioningServices = new LinkedHashMap<VersioningServiceDescriptor, VersioningService>();
    @Deprecated
    protected VersioningRuleRegistry versioningRulesRegistry = new VersioningRuleRegistry();
    @Deprecated
    protected Deque<DefaultVersioningRuleDescriptor> defaultVersioningRuleList = new ArrayDeque<DefaultVersioningRuleDescriptor>();
    public VersioningService service = null;
    protected ComponentContext context;

    public void activate(ComponentContext context) {
        this.context = context;
        this.service = STANDARD_VERSIONING_SERVICE;
    }

    public void deactivate(ComponentContext context) {
        this.context = null;
        this.service = null;
    }

    public void start(ComponentContext context) {
        this.recompute();
    }

    public void registerContribution(Object contrib, String point, ComponentInstance contributor) {
        switch (point) {
            case "versioningService": {
                this.registerVersioningService((VersioningServiceDescriptor)contrib);
                String msg = String.format("Versioning service implementation on component %s is deprecated: use org.nuxeo.ecm.core.api.versioning.VersioningService instead.", VERSIONING_SERVICE_XP);
                DeprecationLogger.log((String)msg, (String)"10.2");
                break;
            }
            case "versioningRules": {
                if (contrib instanceof VersioningRuleDescriptor) {
                    VersioningRuleDescriptor rule = (VersioningRuleDescriptor)contrib;
                    this.registerVersioningRule(rule);
                    ComponentName compName = contributor.getName();
                    String message = String.format("Versioning rule for '%s' on component %s should now be contributed to extension points '%s', '%s' and '%s': a compatibility registration was performed but it may not be accurate.", rule.getTypeName(), compName, VERSIONING_POLICY_XP, VERSIONING_FILTER_XP, VERSIONING_RESTRICTION_XP);
                    DeprecationLogger.log((String)message, (String)"9.1");
                    this.addRuntimeMessage(RuntimeMessage.Level.WARNING, message, RuntimeMessage.Source.EXTENSION, compName.getName());
                    break;
                }
                if (contrib instanceof DefaultVersioningRuleDescriptor) {
                    this.registerDefaultVersioningRule((DefaultVersioningRuleDescriptor)contrib);
                    ComponentName compName = contributor.getName();
                    String message = String.format("Default versioning rule on component %s should now be contributed to extension points '%s' and '%s': a compatibility registration was performed but it may not be accurate.", compName, VERSIONING_POLICY_XP, VERSIONING_RESTRICTION_XP);
                    DeprecationLogger.log((String)message, (String)"9.1");
                    this.addRuntimeMessage(RuntimeMessage.Level.WARNING, message, RuntimeMessage.Source.EXTENSION, compName.getName());
                    break;
                }
                throw new RuntimeException("Unknown contribution to " + point + ": " + contrib.getClass());
            }
            default: {
                throw new RuntimeException("Unknown extension point: " + point);
            }
        }
    }

    public void unregisterContribution(Object contrib, String point, ComponentInstance contributor) {
        switch (point) {
            case "versioningService": {
                this.unregisterVersioningService((VersioningServiceDescriptor)contrib);
                break;
            }
            case "versioningRules": {
                if (contrib instanceof VersioningRuleDescriptor) {
                    this.unregisterVersioningRule((VersioningRuleDescriptor)contrib);
                    break;
                }
                if (!(contrib instanceof DefaultVersioningRuleDescriptor)) break;
                this.unregisterDefaultVersioningRule((DefaultVersioningRuleDescriptor)contrib);
                break;
            }
        }
    }

    protected void registerVersioningService(VersioningServiceDescriptor contrib) {
        String klass = contrib.className;
        try {
            VersioningService vs = (VersioningService)this.context.getRuntimeContext().loadClass(klass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.versioningServices.put(contrib, vs);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to instantiate: " + klass, e);
        }
        log.info((Object)("Registered versioning service: " + klass));
        this.recompute();
    }

    protected void unregisterVersioningService(VersioningServiceDescriptor contrib) {
        this.versioningServices.remove(contrib);
        log.info((Object)("Unregistered versioning service: " + contrib.className));
        this.recompute();
    }

    @Deprecated
    protected void registerVersioningRule(VersioningRuleDescriptor contrib) {
        this.versioningRulesRegistry.addContribution(contrib);
        log.info((Object)("Registered versioning rule: " + contrib.getTypeName()));
        this.recompute();
    }

    @Deprecated
    protected void unregisterVersioningRule(VersioningRuleDescriptor contrib) {
        this.versioningRulesRegistry.removeContribution(contrib);
        log.info((Object)("Unregistered versioning rule: " + contrib.getTypeName()));
        this.recompute();
    }

    @Deprecated
    protected void registerDefaultVersioningRule(DefaultVersioningRuleDescriptor contrib) {
        this.defaultVersioningRuleList.add(contrib);
        this.recompute();
    }

    @Deprecated
    protected void unregisterDefaultVersioningRule(DefaultVersioningRuleDescriptor contrib) {
        this.defaultVersioningRuleList.remove(contrib);
        this.recompute();
    }

    protected void recompute() {
        VersioningService versioningService = STANDARD_VERSIONING_SERVICE;
        for (VersioningService vs : this.versioningServices.values()) {
            versioningService = vs;
        }
        if (versioningService instanceof ExtendableVersioningService) {
            ExtendableVersioningService evs = versioningService;
            evs.setVersioningPolicies(this.getVersioningPolicies());
            evs.setVersioningFilters(this.getVersioningFilters());
            evs.setVersioningRestrictions(this.getVersioningRestrictions());
            evs.setVersioningRules(this.getVersioningRules());
            evs.setDefaultVersioningRule(this.getDefaultVersioningRule());
        }
        this.service = versioningService;
    }

    @Deprecated
    protected Map<String, VersioningRuleDescriptor> getVersioningRules() {
        return this.versioningRulesRegistry.getVersioningRuleDescriptors();
    }

    @Deprecated
    protected DefaultVersioningRuleDescriptor getDefaultVersioningRule() {
        return this.defaultVersioningRuleList.peekLast();
    }

    protected Map<String, VersioningPolicyDescriptor> getVersioningPolicies() {
        return this.getRegistryContributions(VERSIONING_POLICY_XP).stream().sorted().collect(Collectors.toMap(VersioningPolicyDescriptor::getId, Function.identity(), (e1, e2) -> e1, LinkedHashMap::new));
    }

    protected Map<String, VersioningFilterDescriptor> getVersioningFilters() {
        return ((MapRegistry)this.getExtensionPointRegistry(VERSIONING_FILTER_XP)).getContributions();
    }

    protected Map<String, VersioningRestrictionDescriptor> getVersioningRestrictions() {
        return ((MapRegistry)this.getExtensionPointRegistry(VERSIONING_RESTRICTION_XP)).getContributions();
    }

    public String getVersionLabel(DocumentModel doc) {
        return this.service.getVersionLabel(doc);
    }

    public void doPostCreate(Document doc, Map<String, Serializable> options) {
        this.service.doPostCreate(doc, options);
    }

    public List<VersioningOption> getSaveOptions(DocumentModel docModel) {
        return this.service.getSaveOptions(docModel);
    }

    public boolean isPreSaveDoingCheckOut(Document doc, boolean isDirty, VersioningOption option, Map<String, Serializable> options) {
        return this.service.isPreSaveDoingCheckOut(doc, isDirty, option, options);
    }

    public VersioningOption doPreSave(CoreSession session, Document doc, boolean isDirty, VersioningOption option, String checkinComment, Map<String, Serializable> options) {
        return this.service.doPreSave(session, doc, isDirty, option, checkinComment, options);
    }

    public boolean isPostSaveDoingCheckIn(Document doc, VersioningOption option, Map<String, Serializable> options) {
        return this.service.isPostSaveDoingCheckIn(doc, option, options);
    }

    public Document doPostSave(CoreSession session, Document doc, VersioningOption option, String checkinComment, Map<String, Serializable> options) {
        return this.service.doPostSave(session, doc, option, checkinComment, options);
    }

    public Document doCheckIn(Document doc, VersioningOption option, String checkinComment) {
        return this.service.doCheckIn(doc, option, checkinComment);
    }

    public void doCheckOut(Document doc) {
        this.service.doCheckOut(doc);
    }

    public void doAutomaticVersioning(DocumentModel previousDocument, DocumentModel currentDocument, boolean before) {
        this.service.doAutomaticVersioning(previousDocument, currentDocument, before);
    }

    @Deprecated
    protected static class VersioningRuleRegistry
    extends SimpleContributionRegistry<VersioningRuleDescriptor> {
        protected VersioningRuleRegistry() {
        }

        public String getContributionId(VersioningRuleDescriptor contrib) {
            return contrib.getTypeName();
        }

        public VersioningRuleDescriptor clone(VersioningRuleDescriptor orig) {
            return new VersioningRuleDescriptor(orig);
        }

        public void merge(VersioningRuleDescriptor src, VersioningRuleDescriptor dst) {
            dst.merge(src);
        }

        public boolean isSupportingMerge() {
            return true;
        }

        public void contributionUpdated(String id, VersioningRuleDescriptor contrib, VersioningRuleDescriptor newOrigContrib) {
            if (contrib.isEnabled()) {
                this.currentContribs.put(id, contrib);
            } else {
                this.currentContribs.remove(id);
            }
        }

        public void clear() {
            this.currentContribs.clear();
        }

        public Map<String, VersioningRuleDescriptor> getVersioningRuleDescriptors() {
            return this.currentContribs;
        }
    }
}

