/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.core;

import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.publisher.api.AbstractBasePublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.api.PublishingEvent;
import org.nuxeo.ecm.platform.publisher.impl.core.CoreFolderPublicationNode;
import org.nuxeo.ecm.platform.publisher.impl.core.SimpleCorePublishedDocument;

public class CoreProxyFactory
extends AbstractBasePublishedDocumentFactory
implements PublishedDocumentFactory {
    @Override
    public PublishedDocument publishDocument(DocumentModel doc, PublicationNode targetNode, Map<String, String> params) {
        DocumentModel targetDocModel;
        if (targetNode instanceof CoreFolderPublicationNode) {
            CoreFolderPublicationNode coreNode = (CoreFolderPublicationNode)targetNode;
            targetDocModel = coreNode.getTargetDocumentModel();
        } else {
            targetDocModel = this.coreSession.getDocument((DocumentRef)new PathRef(targetNode.getPath()));
        }
        DocumentModel proxy = params != null && params.containsKey("overwriteExistingProxy") ? this.coreSession.publishDocument(doc, targetDocModel, Boolean.parseBoolean(params.get("overwriteExistingProxy"))) : this.coreSession.publishDocument(doc, targetDocModel);
        if (params == null || !"true".equalsIgnoreCase(params.get("batchSave"))) {
            this.coreSession.save();
        }
        this.notifyEvent(PublishingEvent.documentPublished, proxy, this.coreSession);
        return new SimpleCorePublishedDocument(proxy);
    }

    @Override
    public DocumentModel snapshotDocumentBeforePublish(DocumentModel doc) {
        return doc;
    }

    public DocumentModel unwrapPublishedDocument(PublishedDocument pubDoc) {
        if (pubDoc instanceof SimpleCorePublishedDocument) {
            SimpleCorePublishedDocument pubProxy = (SimpleCorePublishedDocument)pubDoc;
            return pubProxy.getProxy();
        }
        throw new NuxeoException("factory can not unwrap this PublishedDocument");
    }

    @Override
    public PublishedDocument wrapDocumentModel(DocumentModel doc) {
        return new SimpleCorePublishedDocument(doc);
    }
}

