/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.api.PublisherService;
import org.nuxeo.ecm.platform.publisher.descriptors.PublicationTreeConfigDescriptor;
import org.nuxeo.ecm.platform.publisher.descriptors.PublicationTreeDescriptor;
import org.nuxeo.ecm.platform.publisher.descriptors.PublishedDocumentFactoryDescriptor;
import org.nuxeo.ecm.platform.publisher.helper.PublicationRelationHelper;
import org.nuxeo.ecm.platform.publisher.helper.RootSectionFinder;
import org.nuxeo.ecm.platform.publisher.helper.RootSectionFinderFactory;
import org.nuxeo.ecm.platform.publisher.impl.finder.DefaultRootSectionsFinder;
import org.nuxeo.ecm.platform.publisher.impl.service.DomainsFinder;
import org.nuxeo.ecm.platform.publisher.rules.ValidatorsRule;
import org.nuxeo.ecm.platform.publisher.rules.ValidatorsRuleDescriptor;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class PublisherServiceImpl
extends DefaultComponent
implements PublisherService,
ComponentManager.Listener {
    private static final Logger log = LogManager.getLogger(PublisherServiceImpl.class);
    public static final String TREE_EP = "tree";
    public static final String TREE_CONFIG_EP = "treeInstance";
    public static final String VALIDATORS_RULE_EP = "validatorsRule";
    public static final String FACTORY_EP = "factory";
    public static final String ROOT_SECTION_FINDER_FACTORY_EP = "rootSectionFinderFactory";
    protected static final String ROOT_PATH_KEY = "RootPath";
    protected static final String RELATIVE_ROOT_PATH_KEY = "RelativeRootPath";
    protected Map<String, PublicationTreeConfigDescriptor> treeConfigDescriptors;
    protected Map<String, PublicationTreeConfigDescriptor> pendingDescriptors;
    protected RootSectionFinderFactory rootSectionFinderFactory;

    public void start(ComponentContext context) {
        this.treeConfigDescriptors = new ConcurrentHashMap<String, PublicationTreeConfigDescriptor>();
        this.pendingDescriptors = new ConcurrentHashMap<String, PublicationTreeConfigDescriptor>();
        this.getRegistryContributions(TREE_CONFIG_EP).forEach(desc -> {
            if (desc.getParameters().get(RELATIVE_ROOT_PATH_KEY) != null) {
                this.pendingDescriptors.put(desc.getName(), (PublicationTreeConfigDescriptor)desc);
            } else {
                this.treeConfigDescriptors.put(desc.getName(), (PublicationTreeConfigDescriptor)desc);
            }
        });
        this.getRegistryContribution(ROOT_SECTION_FINDER_FACTORY_EP).ifPresent(desc -> {
            try {
                this.rootSectionFinderFactory = desc.getFactory().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                String message = String.format("Unable to load custom RootSectionFinderFactory (%s)", e.getMessage());
                this.addRuntimeMessage(RuntimeMessage.Level.ERROR, message);
                log.error(message, (Throwable)e);
            }
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.treeConfigDescriptors = null;
        this.pendingDescriptors = null;
        this.rootSectionFinderFactory = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterRuntimeStart(ComponentManager mgr, boolean isResume) {
        RepositoryService repositoryService = (RepositoryService)Framework.getService(RepositoryService.class);
        if (repositoryService == null) {
            return;
        }
        boolean txWasStartedOutsideComponent = TransactionHelper.isTransactionActiveOrMarkedRollback();
        if (txWasStartedOutsideComponent || TransactionHelper.startTransaction()) {
            boolean completedAbruptly = true;
            try {
                this.doApplicationStarted();
                completedAbruptly = false;
            }
            finally {
                if (completedAbruptly) {
                    TransactionHelper.setTransactionRollbackOnly();
                }
                if (!txWasStartedOutsideComponent) {
                    TransactionHelper.commitOrRollbackTransaction();
                }
            }
        } else {
            this.doApplicationStarted();
        }
    }

    protected void doApplicationStarted() {
        ClassLoader jbossCL = Thread.currentThread().getContextClassLoader();
        ClassLoader nuxeoCL = PublisherServiceImpl.class.getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(nuxeoCL);
            log.info("Publisher Service initialization");
            this.registerPendingDescriptors();
        }
        finally {
            Thread.currentThread().setContextClassLoader(jbossCL);
            log.debug("JBoss ClassLoader restored");
        }
    }

    @Override
    public List<String> getAvailablePublicationTree() {
        ArrayList<String> treeConfigs = new ArrayList<String>();
        treeConfigs.addAll(this.treeConfigDescriptors.keySet());
        return treeConfigs;
    }

    @Override
    public Map<String, String> getAvailablePublicationTrees() {
        HashMap<String, String> trees = new HashMap<String, String>();
        for (PublicationTreeConfigDescriptor desc : this.treeConfigDescriptors.values()) {
            String title = desc.getTitle() == null ? desc.getName() : desc.getTitle();
            trees.put(desc.getName(), title);
        }
        return trees;
    }

    @Override
    public PublicationTree getPublicationTree(String treeName, CoreSession coreSession, Map<String, String> params) {
        return this.getPublicationTree(treeName, coreSession, params, null);
    }

    @Override
    public PublicationTree getPublicationTree(String treeName, CoreSession coreSession, Map<String, String> params, DocumentModel currentDocument) {
        PublicationTree tree = this.buildTree(treeName, coreSession, params);
        if (tree == null) {
            return null;
        }
        if (currentDocument != null) {
            tree.setCurrentDocument(currentDocument);
        }
        return tree;
    }

    protected PublicationTree buildTree(String treeConfigName, CoreSession coreSession, Map<String, String> params) {
        PublicationTreeConfigDescriptor config = this.getPublicationTreeConfigDescriptor(treeConfigName);
        Map<String, String> allParameters = this.computeAllParameters(config, params);
        PublicationTreeDescriptor treeDescriptor = this.getPublicationTreeDescriptor(config);
        PublishedDocumentFactory publishedDocumentFactory = this.getPublishedDocumentFactory(config, treeDescriptor, coreSession, allParameters);
        return this.getPublicationTree(treeDescriptor, coreSession, allParameters, publishedDocumentFactory, config.getName(), config.getTitle());
    }

    protected Map<String, String> computeAllParameters(PublicationTreeConfigDescriptor config, Map<String, String> params) {
        Map<String, String> allParameters = config.getParameters();
        if (params != null) {
            allParameters.putAll(params);
        }
        return allParameters;
    }

    protected PublishedDocumentFactory getPublishedDocumentFactory(PublicationTreeConfigDescriptor config, PublicationTreeDescriptor treeDescriptor, CoreSession coreSession, Map<String, String> params) {
        PublishedDocumentFactory factory;
        PublishedDocumentFactoryDescriptor factoryDesc = this.getPublishedDocumentFactoryDescriptor(config, treeDescriptor);
        ValidatorsRule validatorsRule = this.getValidatorsRule(factoryDesc);
        try {
            factory = factoryDesc.getKlass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException("Error while creating factory " + factoryDesc.getName(), (Throwable)e);
        }
        factory.init(coreSession, validatorsRule, params);
        return factory;
    }

    protected ValidatorsRule getValidatorsRule(PublishedDocumentFactoryDescriptor factoryDesc) {
        String ruleName = factoryDesc.getValidatorsRuleName();
        ValidatorsRule rule = null;
        if (ruleName != null) {
            ValidatorsRuleDescriptor desc = (ValidatorsRuleDescriptor)this.getRegistryContribution(VALIDATORS_RULE_EP, ruleName).orElseThrow(() -> new NuxeoException("Unable to find validatorsRule" + ruleName));
            try {
                rule = desc.getKlass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new NuxeoException("Error while creating validatorsRule " + ruleName, (Throwable)e);
            }
        }
        return rule;
    }

    protected PublishedDocumentFactoryDescriptor getPublishedDocumentFactoryDescriptor(PublicationTreeConfigDescriptor config, PublicationTreeDescriptor treeDescriptor) {
        String factoryName = config.getFactory();
        if (factoryName == null) {
            factoryName = treeDescriptor.getFactory();
        }
        if (factoryName == null) {
            throw new NuxeoException(String.format("No factory for descriptors %s and %s", config.getName(), treeDescriptor.getName()));
        }
        String name = factoryName;
        return (PublishedDocumentFactoryDescriptor)this.getRegistryContribution(FACTORY_EP, name).orElseThrow(() -> new NuxeoException("Unable to find factory " + name));
    }

    protected PublicationTreeConfigDescriptor getPublicationTreeConfigDescriptor(String treeConfigName) {
        if (!this.treeConfigDescriptors.containsKey(treeConfigName)) {
            throw new NuxeoException("Unknow treeConfig :" + treeConfigName);
        }
        return this.treeConfigDescriptors.get(treeConfigName);
    }

    protected PublicationTreeDescriptor getPublicationTreeDescriptor(PublicationTreeConfigDescriptor config) {
        String treeImplName = config.getTree();
        return (PublicationTreeDescriptor)this.getRegistryContribution(TREE_EP, treeImplName).orElseThrow(() -> new NuxeoException("Unknow treeImplementation:" + treeImplName));
    }

    protected PublicationTree getPublicationTree(PublicationTreeDescriptor treeDescriptor, CoreSession coreSession, Map<String, String> parameters, PublishedDocumentFactory factory, String configName, String treeTitle) {
        PublicationTree treeImpl;
        try {
            treeImpl = treeDescriptor.getKlass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException("Error while creating tree implementation", (Throwable)e);
        }
        treeImpl.initTree(coreSession, parameters, factory, configName, treeTitle);
        return treeImpl;
    }

    @Override
    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode) {
        return this.publish(doc, targetNode, null);
    }

    @Override
    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode, Map<String, String> params) {
        return targetNode.getTree().publish(doc, targetNode, params);
    }

    @Override
    public void unpublish(DocumentModel doc, PublicationNode targetNode) {
        targetNode.getTree().unpublish(doc, targetNode);
    }

    @Override
    public boolean isPublishedDocument(DocumentModel documentModel) {
        return PublicationRelationHelper.isPublished(documentModel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PublicationTree getPublicationTreeFor(DocumentModel doc, CoreSession coreSession) {
        PublicationTree tree = null;
        try {
            return PublicationRelationHelper.getPublicationTreeUsedForPublishing(doc, coreSession);
        }
        catch (NuxeoException e) {
            String treeName;
            log.error("Unable to get PublicationTree for {}. Fallback on first PublicationTree accepting this document.", (Object)doc.getPathAsString(), (Object)e);
            Iterator<String> iterator = this.treeConfigDescriptors.keySet().iterator();
            do {
                if (!iterator.hasNext()) return tree;
            } while (!(tree = this.getPublicationTree(treeName = iterator.next(), coreSession, null)).isPublicationNode(doc));
        }
        return tree;
    }

    @Override
    public PublicationNode wrapToPublicationNode(DocumentModel documentModel, CoreSession coreSession) {
        for (String name : this.getAvailablePublicationTree()) {
            PublicationTree tree = this.getPublicationTree(name, coreSession, null);
            if (!tree.isPublicationNode(documentModel)) continue;
            return tree.wrapToPublicationNode(documentModel);
        }
        return null;
    }

    protected void registerPendingDescriptors() {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        String repositoryName = repositoryManager.getDefaultRepositoryName();
        List<DocumentModel> domains = new DomainsFinder(repositoryName).getDomains();
        for (DocumentModel domain : domains) {
            this.registerTreeConfigFor(domain);
        }
    }

    protected String getPendingTreeConfigName(PublicationTreeConfigDescriptor desc, String domainName) {
        return desc.getName() + "-" + domainName;
    }

    public void registerTreeConfigFor(DocumentModel domain) {
        for (PublicationTreeConfigDescriptor desc : this.pendingDescriptors.values()) {
            String newTreeName = this.getPendingTreeConfigName(desc, domain.getName());
            PublicationTreeConfigDescriptor newDesc = new PublicationTreeConfigDescriptor(newTreeName, desc);
            Path newPath = domain.getPath();
            Map<String, String> parameters = newDesc.getParameters();
            newPath = newPath.append(parameters.remove(RELATIVE_ROOT_PATH_KEY));
            parameters.put(ROOT_PATH_KEY, newPath.toString());
            parameters.put("DomainName", domain.getTitle());
            this.treeConfigDescriptors.put(newDesc.getName(), newDesc);
        }
    }

    public void unRegisterTreeConfigFor(DocumentModel domain) {
        this.unRegisterTreeConfigFor(domain.getName());
    }

    public void unRegisterTreeConfigFor(String domainName) {
        for (PublicationTreeConfigDescriptor desc : this.pendingDescriptors.values()) {
            String treeName = this.getPendingTreeConfigName(desc, domainName);
            this.treeConfigDescriptors.remove(treeName);
        }
    }

    @Override
    public Map<String, String> getParametersFor(String treeConfigName) {
        PublicationTreeConfigDescriptor desc = this.treeConfigDescriptors.get(treeConfigName);
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (desc != null) {
            parameters.putAll(desc.getParameters());
        }
        return parameters;
    }

    @Override
    public RootSectionFinder getRootSectionFinder(CoreSession session) {
        if (this.rootSectionFinderFactory != null) {
            return this.rootSectionFinderFactory.getRootSectionFinder(session);
        }
        return new DefaultRootSectionsFinder(session);
    }
}

