/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.automation.scripting.internals;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.automation.scripting.api.AutomationScriptingService;
import org.nuxeo.automation.scripting.internals.ScriptingOperationDescriptor;
import org.nuxeo.automation.scripting.internals.ScriptingOperationImpl;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.runtime.api.Framework;

public class ScriptingOperationTypeImpl
implements OperationType {
    protected final ScriptingOperationDescriptor desc;
    protected final InvokableMethod method;

    public ScriptingOperationTypeImpl(ScriptingOperationDescriptor desc) {
        this.desc = desc;
        this.method = ScriptingOperationTypeImpl.runMethod(this, desc.getInputType());
    }

    public String getContributingComponent() {
        return this.desc.getContributingComponent();
    }

    public OperationDocumentation getDocumentation() {
        OperationDocumentation doc = new OperationDocumentation(this.getId());
        doc.label = this.getId();
        doc.category = this.desc.getCategory();
        doc.description = this.desc.getDescription();
        doc.params = this.desc.getParams();
        doc.signature = new String[]{this.desc.getInputType(), this.desc.getOutputType()};
        doc.aliases = this.desc.getAliases();
        return doc;
    }

    public String getId() {
        return this.desc.getId();
    }

    public String[] getAliases() {
        return this.desc.getAliases();
    }

    public Object newInstance(OperationContext ctx, Map<String, Object> args) throws OperationException {
        HashMap<String, Object> params = new HashMap<String, Object>(args);
        ((AutomationScriptingService)Framework.getService(AutomationScriptingService.class)).getParametersInjector().inject(params, ctx, this.desc);
        return new ScriptingOperationImpl(this.desc.source, ctx, params);
    }

    public Class<?> getType() {
        return ScriptingOperationImpl.class;
    }

    public String getInputType() {
        return this.desc.getInputType();
    }

    public InvokableMethod[] getMethodsMatchingInput(Class<?> in) {
        return new InvokableMethod[]{this.method};
    }

    public List<InvokableMethod> getMethods() {
        return Collections.singletonList(this.method);
    }

    protected static InvokableMethod runMethod(ScriptingOperationTypeImpl op, String inputType) {
        try {
            Method method = inputType == null ? ScriptingOperationImpl.class.getMethod("run", new Class[0]) : ScriptingOperationImpl.class.getMethod("run", Object.class);
            return new InvokableMethod((OperationType)op, method);
        }
        catch (ReflectiveOperationException cause) {
            throw new Error("Cannot reference run method of " + ScriptingOperationImpl.class);
        }
    }
}

