/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.ecm.platform.video.Stream;

public final class VideoInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Pattern FORMAT_PATTERN = Pattern.compile("^\\s*(Input|Output) #0, ([\\w,]+).+$\\s*", 2);
    public static final Pattern DURATION_PATTERN = Pattern.compile("Duration: (\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d+)", 2);
    public static final Pattern STREAM_PATTERN = Pattern.compile("^\\s*Stream #\\S+: ((?:Audio)|(?:Video)|(?:Data)): (.*)\\s*$", 2);
    public static final Pattern SIZE_PATTERN = Pattern.compile("(\\d+)x(\\d+)", 2);
    public static final Pattern FRAME_RATE_PATTERN = Pattern.compile("([\\d.]+)\\s+(?:fps|tbr)", 2);
    public static final Pattern BIT_RATE_PATTERN = Pattern.compile("(\\d+)\\s+kb/s", 2);
    public static final Pattern METADATA_ROTATE_PATTERN = Pattern.compile("\\s*rotate\\s*:\\s*(\\d+)\\s*", 2);
    public static final VideoInfo EMPTY_INFO = new VideoInfo(0.0, 0L, 0L, 0.0, null, null);
    public static final String DURATION = "duration";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String FRAME_RATE = "frameRate";
    public static final String FORMAT = "format";
    public static final String STREAMS = "streams";
    private final double duration;
    private final long width;
    private final long height;
    private final String format;
    private final List<Stream> streams;
    private final double frameRate;

    public static VideoInfo fromMap(Map<String, Serializable> map) {
        Double frameRate;
        String format;
        Long height;
        Long width;
        Double duration = (Double)map.get(DURATION);
        if (duration == null) {
            duration = 0.0;
        }
        if ((width = (Long)map.get(WIDTH)) == null) {
            width = 0L;
        }
        if ((height = (Long)map.get(HEIGHT)) == null) {
            height = 0L;
        }
        if ((format = (String)((Object)map.get(FORMAT))) == null) {
            format = "";
        }
        if ((frameRate = (Double)map.get(FRAME_RATE)) == null) {
            frameRate = 0.0;
        }
        ArrayList<Stream> streams = new ArrayList<Stream>();
        List streamItems = (List)((Object)map.get(STREAMS));
        if (streamItems != null) {
            for (Map m : streamItems) {
                streams.add(Stream.fromMap(m));
            }
        }
        return new VideoInfo(duration, width, height, frameRate, format, streams);
    }

    public static VideoInfo fromFFmpegOutput(List<String> output) {
        double duration = 0.0;
        long width = 0L;
        long height = 0L;
        double frameRate = 0.0;
        double bitRate = 0.0;
        String format = "";
        ArrayList<Stream> streams = new ArrayList<Stream>();
        for (String line : output) {
            long rotate;
            Matcher matcher = FORMAT_PATTERN.matcher(line);
            if (matcher.find()) {
                format = matcher.group(2).trim();
                if (!format.endsWith(",")) continue;
                format = format.substring(0, format.length() - 1);
                continue;
            }
            matcher = DURATION_PATTERN.matcher(line);
            if (matcher.find()) {
                duration = Double.parseDouble(matcher.group(1)) * 3600.0 + Double.parseDouble(matcher.group(2)) * 60.0 + Double.parseDouble(matcher.group(3)) + Double.parseDouble(matcher.group(4)) / 100.0;
                continue;
            }
            matcher = STREAM_PATTERN.matcher(line);
            if (matcher.find()) {
                Matcher m;
                String streamType = matcher.group(1).trim();
                String specs = matcher.group(2);
                String[] tokens = specs.split(",");
                if ("Video".equals(streamType)) {
                    for (String token : tokens) {
                        m = FRAME_RATE_PATTERN.matcher(token);
                        if (m.find()) {
                            frameRate = Double.parseDouble(m.group(1));
                            continue;
                        }
                        m = SIZE_PATTERN.matcher(token);
                        if (m.find()) {
                            width = Long.parseLong(m.group(1));
                            height = Long.parseLong(m.group(2));
                            continue;
                        }
                        m = BIT_RATE_PATTERN.matcher(token);
                        if (!m.find()) continue;
                        bitRate = Double.parseDouble(m.group(1));
                    }
                } else if ("Audio".equals(streamType)) {
                    for (String token : tokens) {
                        m = BIT_RATE_PATTERN.matcher(token);
                        if (!m.find()) continue;
                        bitRate = Double.parseDouble(m.group(1));
                    }
                }
                HashMap<String, Serializable> map = new HashMap<String, Serializable>();
                map.put("type", (Serializable)((Object)streamType));
                map.put("codec", (Serializable)((Object)tokens[0]));
                map.put("streamInfo", (Serializable)((Object)matcher.group(0).trim()));
                map.put("bitRate", Double.valueOf(bitRate));
                streams.add(Stream.fromMap(map));
            }
            if (!(matcher = METADATA_ROTATE_PATTERN.matcher(line)).find() || (rotate = Long.parseLong(matcher.group(1))) != 90L && rotate != 270L) continue;
            long temp = width;
            width = height;
            height = temp;
        }
        return new VideoInfo(duration, width, height, frameRate, format, streams);
    }

    private VideoInfo(double duration, long width, long height, double frameRate, String format, List<Stream> streams) {
        this.duration = duration;
        this.width = width;
        this.height = height;
        this.frameRate = frameRate;
        this.format = format;
        this.streams = new ArrayList<Stream>();
        if (streams != null) {
            this.streams.addAll(streams);
        }
    }

    public double getDuration() {
        return this.duration;
    }

    public long getWidth() {
        return this.width;
    }

    public long getHeight() {
        return this.height;
    }

    public String getFormat() {
        return this.format;
    }

    public List<Stream> getStreams() {
        return this.streams;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public Map<String, Serializable> toMap() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(DURATION, Double.valueOf(this.duration));
        map.put(FRAME_RATE, Double.valueOf(this.frameRate));
        map.put(WIDTH, Long.valueOf(this.width));
        map.put(HEIGHT, Long.valueOf(this.height));
        map.put(FORMAT, (Serializable)((Object)this.format));
        ArrayList<Map<String, Serializable>> streamItems = new ArrayList<Map<String, Serializable>>(this.streams.size());
        for (Stream stream : this.streams) {
            streamItems.add(stream.toMap());
        }
        map.put(STREAMS, streamItems);
        return map;
    }
}

