/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.service;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.ecm.platform.video.VideoHelper;
import org.nuxeo.ecm.platform.video.service.VideoService;
import org.nuxeo.ecm.platform.video.service.VideoStoryboardWork;
import org.nuxeo.runtime.api.Framework;

public class VideoInfoWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(VideoInfoWork.class);
    public static final String CATEGORY_VIDEO_INFO = "videoInfo";

    protected static String computeIdPrefix(String repositoryName, String docId) {
        return repositoryName + ":" + docId + ":videoinfo:";
    }

    public VideoInfoWork(String repositoryName, String docId) {
        super(VideoInfoWork.computeIdPrefix(repositoryName, docId));
        this.setDocument(repositoryName, docId);
    }

    public boolean isIdempotent() {
        return false;
    }

    public String getCategory() {
        return CATEGORY_VIDEO_INFO;
    }

    public String getTitle() {
        return "Video Info: " + this.getId();
    }

    public void work() {
        this.setStatus("Updating video info");
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        this.openSystemSession();
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        this.updateVideoInfo(doc);
        if (doc.hasFacet("HasVideoPreview") && doc.hasFacet("HasStoryboard")) {
            WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
            VideoStoryboardWork work = new VideoStoryboardWork(doc.getRepositoryName(), doc.getId());
            log.debug((Object)String.format("Scheduling work: storyboard of Video document %s.", doc));
            workManager.schedule((Work)work, true);
        }
        VideoService videoService = (VideoService)Framework.getService(VideoService.class);
        log.debug((Object)String.format("Launching automatic conversions of Video document %s.", doc));
        videoService.launchAutomaticConversions(doc, true);
        this.setStatus("Done");
    }

    protected void updateVideoInfo(DocumentModel doc) {
        VideoDocument videoDocument = (VideoDocument)doc.getAdapter(VideoDocument.class);
        if (videoDocument.getVideo().getWidth() != 0L && videoDocument.getVideo().getHeight() != 0L) {
            return;
        }
        BlobHolder blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class);
        Blob video = blobHolder.getBlob();
        log.debug((Object)String.format("Updating video info of document %s.", doc));
        VideoHelper.updateVideoInfo(doc, video);
        log.debug((Object)String.format("End updating video info of document %s.", doc));
        if (doc.isVersion()) {
            doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
        }
        this.session.saveDocument(doc);
    }
}

