/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.service;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.video.TranscodedVideo;
import org.nuxeo.ecm.platform.video.Video;
import org.nuxeo.ecm.platform.video.VideoConversionStatus;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.ecm.platform.video.VideoHelper;
import org.nuxeo.ecm.platform.video.VideoInfo;
import org.nuxeo.ecm.platform.video.service.AutomaticVideoConversion;
import org.nuxeo.ecm.platform.video.service.Configuration;
import org.nuxeo.ecm.platform.video.service.VideoConversion;
import org.nuxeo.ecm.platform.video.service.VideoConversionWork;
import org.nuxeo.ecm.platform.video.service.VideoService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class VideoServiceImpl
extends DefaultComponent
implements VideoService {
    protected static final Log log = LogFactory.getLog(VideoServiceImpl.class);
    public static final String VIDEO_CONVERSIONS_EP = "videoConversions";
    public static final String DEFAULT_VIDEO_CONVERSIONS_EP = "automaticVideoConversions";
    public static final String CONFIGURATION_EP = "configuration";
    protected Configuration configuration;

    public void start(ComponentContext context) {
        this.configuration = this.getRegistryContribution(CONFIGURATION_EP).orElse(Configuration.DEFAULT_CONFIGURATION);
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.configuration = null;
    }

    public void deactivate(ComponentContext context) {
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        if (workManager != null && workManager.isStarted()) {
            try {
                workManager.shutdownQueue(workManager.getCategoryQueueId("videoConversion"), 10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new NuxeoException((Throwable)e);
            }
        }
    }

    @Override
    public Collection<VideoConversion> getAvailableVideoConversions() {
        return this.getRegistryContributions(VIDEO_CONVERSIONS_EP);
    }

    @Override
    public void launchConversion(DocumentModel doc, String conversionName) {
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        VideoConversionWork work = new VideoConversionWork(doc.getRepositoryName(), doc.getId(), conversionName);
        log.debug((Object)String.format("Scheduling work: %s conversion of Video document %s.", conversionName, doc));
        workManager.schedule((Work)work, true);
    }

    @Override
    public void launchAutomaticConversions(DocumentModel doc, boolean onlyMissing) {
        List conversions = this.getRegistryContributions(DEFAULT_VIDEO_CONVERSIONS_EP);
        Collections.sort(conversions);
        VideoDocument videoDocument = (VideoDocument)doc.getAdapter(VideoDocument.class);
        for (AutomaticVideoConversion conversion : conversions) {
            if (onlyMissing && videoDocument.getTranscodedVideo(conversion.getName()) != null) continue;
            this.launchConversion(doc, conversion.getName());
        }
    }

    @Override
    public TranscodedVideo convert(Video originalVideo, String conversionName) {
        VideoConversion conversion = (VideoConversion)this.getRegistryContribution(VIDEO_CONVERSIONS_EP, conversionName).orElseThrow(() -> new NuxeoException(String.format("'%s' is not a registered video conversion.", conversionName)));
        SimpleBlobHolder blobHolder = new SimpleBlobHolder(originalVideo.getBlob());
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
        parameters.put("height", Long.valueOf(conversion.getHeight()));
        parameters.put("videoInfo", originalVideo.getVideoInfo());
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        BlobHolder result = conversionService.convert(conversion.getConverter(), (BlobHolder)blobHolder, parameters);
        VideoInfo videoInfo = VideoHelper.getVideoInfo(result.getBlob());
        return TranscodedVideo.fromBlobAndInfo(conversionName, result.getBlob(), videoInfo);
    }

    @Override
    public VideoConversionStatus getProgressStatus(String repositoryName, String docId, String conversionName) {
        VideoConversionWork work;
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        Work.State state = workManager.getWorkState((work = new VideoConversionWork(repositoryName, docId, conversionName)).getId());
        if (state == null) {
            return null;
        }
        if (state == Work.State.SCHEDULED) {
            String queueId = workManager.getCategoryQueueId("videoConversion");
            long queueSize = workManager.getQueueSize(queueId, Work.State.SCHEDULED);
            return new VideoConversionStatus("status.video.conversionQueued", 0L, queueSize);
        }
        return new VideoConversionStatus("status.video.conversionPending", 0L, 0L);
    }

    @Override
    public VideoConversion getVideoConversion(String conversionName) {
        return this.getRegistryContribution(VIDEO_CONVERSIONS_EP, conversionName).orElse(null);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }
}

