/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.tools.operations;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.video.tools.VideoToolsService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Video.Concat", category="Files", label="Joins two or more videos sequentially.", description="Merge 2-n videos in one.")
public class ConcatVideos {
    public static final String ID = "Video.Concat";
    @Param(name="xpath", required=false)
    protected String xpath;

    @OperationMethod
    public Blob run(BlobList blobs) throws NuxeoException, IOException, CommandNotAvailable {
        VideoToolsService service = (VideoToolsService)Framework.getService(VideoToolsService.class);
        return service.concat((List<Blob>)blobs);
    }

    @OperationMethod
    public Blob run(DocumentModelList docs) throws NuxeoException, IOException, CommandNotAvailable {
        BlobList blobs = new BlobList();
        for (DocumentModel doc : docs) {
            if (StringUtils.isEmpty((CharSequence)this.xpath)) {
                blobs.add((Object)((BlobHolder)doc.getAdapter(BlobHolder.class)).getBlob());
                continue;
            }
            blobs.add((Object)((Blob)doc.getPropertyValue(this.xpath)));
        }
        return this.run(blobs);
    }
}

