/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.tools.operations;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.BlobCollector;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.video.tools.VideoToolsService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Video.ExtractClosedCaptions", category="Conversion", label="Extracts closed captions from the video.", description="Extracts the closed captions from the whole video or from a part of it when startAt and end time is provided. The output format references how the output is generated, and xpath can be used to indicate the video blob when using documents.")
public class ExtractClosedCaptionsFromVideo {
    public static final String ID = "Video.ExtractClosedCaptions";
    @Param(name="outFormat", required=false, values={"ttxt", "srt", "txt"})
    protected String outFormat;
    @Param(name="startAt", required=false)
    protected String startAt;
    @Param(name="endAt", required=false)
    protected String endAt;
    @Param(name="xpath", required=false)
    protected String xpath;

    @OperationMethod
    public Blob run(DocumentModel input) throws OperationException {
        if (StringUtils.isEmpty((CharSequence)this.xpath)) {
            return this.run(((BlobHolder)input.getAdapter(BlobHolder.class)).getBlob());
        }
        return this.run((Blob)input.getPropertyValue(this.xpath));
    }

    @OperationMethod
    public BlobList run(DocumentModelList input) throws OperationException {
        BlobList blobList = new BlobList();
        for (DocumentModel doc : input) {
            blobList.add((Object)this.run(doc));
        }
        return blobList;
    }

    @OperationMethod(collector=BlobCollector.class)
    public Blob run(Blob input) throws OperationException {
        try {
            VideoToolsService service = (VideoToolsService)Framework.getService(VideoToolsService.class);
            return service.extractClosedCaptions(input, this.outFormat, this.startAt, this.endAt);
        }
        catch (NuxeoException e) {
            throw new OperationException((Throwable)e);
        }
    }
}

