/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DetachedAdapter;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.LifeCycleException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.LockException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.types.Schema;

public interface CoreSession {
    public static final String IMPORT_VERSION_VERSIONABLE_ID = "ecm:versionableId";
    public static final String IMPORT_VERSION_CREATED = "ecm:versionCreated";
    public static final String IMPORT_VERSION_LABEL = "ecm:versionLabel";
    public static final String IMPORT_VERSION_DESCRIPTION = "ecm:versionDescription";
    public static final String IMPORT_VERSION_IS_LATEST = "ecm:isLatestVersion";
    public static final String IMPORT_VERSION_IS_LATEST_MAJOR = "ecm:isLatestMajorVersion";
    public static final String IMPORT_IS_VERSION = "ecm:isVersion";
    public static final String IMPORT_VERSION_MAJOR = "ecm:majorVersion";
    public static final String IMPORT_VERSION_MINOR = "ecm:minorVersion";
    public static final String IMPORT_IS_RECORD = "ecm:isRecord";
    public static final String IMPORT_RETAIN_UNTIL = "ecm:retainUntil";
    public static final String IMPORT_HAS_LEGAL_HOLD = "ecm:hasLegalHold";
    @Deprecated
    public static final String IMPORT_IS_RETENTION_ACTIVE = "ecm:isRetentionActive";
    public static final String IMPORT_PROXY_TARGET_ID = "ecm:proxyTargetId";
    public static final String IMPORT_PROXY_VERSIONABLE_ID = "ecm:proxyVersionableId";
    public static final String IMPORT_LIFECYCLE_POLICY = "ecm:lifeCyclePolicy";
    public static final String IMPORT_LIFECYCLE_STATE = "ecm:lifeCycleState";
    public static final String IMPORT_LOCK_OWNER = "ecm:lockOwner";
    public static final String IMPORT_LOCK_CREATED = "ecm:lockCreated";
    public static final String IMPORT_CHECKED_IN = "ecm:isCheckedIn";
    public static final String IMPORT_BASE_VERSION_ID = "ecm:baseVersionId";
    public static final String IMPORT_PROXY_TYPE = "ecm:proxy";
    public static final String SKIP_DESTINATION_CHECK_ON_CREATE = "skipDestinationCheck";
    public static final String ALLOW_VERSION_WRITE = "allowVersionWrite";
    public static final String SOURCE = "source";
    public static final String CHANGE_TOKEN = "changeToken";
    public static final String USER_CHANGE = "userChange";
    public static final String RETAIN_UNTIL_INDETERMINATE_ISO = "9999-01-01T00:00Z";
    public static final Calendar RETAIN_UNTIL_INDETERMINATE = GregorianCalendar.from(ZonedDateTime.parse("9999-01-01T00:00Z"));
    public static final String BINARY_FULLTEXT_MAIN_KEY = "binarytext";

    @Deprecated
    public void close();

    public DocumentType getDocumentType(String var1);

    public void cancel();

    public void save();

    @Deprecated
    public String getSessionId();

    @Deprecated
    public boolean isStateSharedByAllThreadSessions();

    public NuxeoPrincipal getPrincipal();

    public boolean hasPermission(DocumentRef var1, String var2);

    public boolean hasPermission(NuxeoPrincipal var1, DocumentRef var2, String var3);

    public Collection<String> filterGrantedPermissions(NuxeoPrincipal var1, DocumentRef var2, Collection<String> var3);

    public DocumentModel getRootDocument();

    public DocumentModel getDocument(DocumentRef var1) throws DocumentNotFoundException;

    public DocumentModelList getDocuments(DocumentRef[] var1) throws DocumentNotFoundException;

    public DocumentModel getChild(DocumentRef var1, String var2);

    public boolean hasChild(DocumentRef var1, String var2);

    public DocumentModelList getChildren(DocumentRef var1);

    public DocumentModelIterator getChildrenIterator(DocumentRef var1);

    public DocumentModelList getChildren(DocumentRef var1, String var2);

    public DocumentModelIterator getChildrenIterator(DocumentRef var1, String var2);

    public DocumentModelList getChildren(DocumentRef var1, String var2, String var3);

    public DocumentModelList getChildren(DocumentRef var1, String var2, String var3, Filter var4, Sorter var5);

    public List<DocumentRef> getChildrenRefs(DocumentRef var1, String var2);

    public DocumentModelIterator getChildrenIterator(DocumentRef var1, String var2, String var3, Filter var4);

    public DocumentModelList getChildren(DocumentRef var1, String var2, Filter var3, Sorter var4);

    public DocumentModelList getFolders(DocumentRef var1);

    public DocumentModelList getFolders(DocumentRef var1, Filter var2, Sorter var3);

    public DocumentModelList getFiles(DocumentRef var1);

    public DocumentModelList getFiles(DocumentRef var1, Filter var2, Sorter var3);

    public DocumentRef getParentDocumentRef(DocumentRef var1);

    public DocumentModel getParentDocument(DocumentRef var1);

    public List<DocumentModel> getParentDocuments(DocumentRef var1);

    public boolean exists(DocumentRef var1);

    public boolean hasChildren(DocumentRef var1);

    public DocumentModel createDocumentModel(String var1);

    public DocumentModel createDocumentModel(String var1, String var2, String var3);

    public DocumentModel newDocumentModel(DocumentRef var1, String var2, String var3);

    public DocumentModel createDocumentModel(String var1, Map<String, Object> var2);

    public DocumentModel createDocument(DocumentModel var1);

    public DocumentModel[] createDocument(DocumentModel[] var1);

    public void importDocuments(List<DocumentModel> var1);

    public DocumentModel saveDocument(DocumentModel var1);

    public void saveDocuments(DocumentModel[] var1);

    public boolean canRemoveDocument(DocumentRef var1);

    public void removeDocument(DocumentRef var1);

    public void removeDocuments(DocumentRef[] var1);

    public void removeChildren(DocumentRef var1);

    public DocumentModel copy(DocumentRef var1, DocumentRef var2, String var3, CopyOption ... var4);

    @Deprecated
    public DocumentModel copy(DocumentRef var1, DocumentRef var2, String var3, boolean var4);

    public List<DocumentModel> copy(List<DocumentRef> var1, DocumentRef var2, CopyOption ... var3);

    @Deprecated
    public List<DocumentModel> copy(List<DocumentRef> var1, DocumentRef var2, boolean var3);

    public DocumentModel copyProxyAsDocument(DocumentRef var1, DocumentRef var2, String var3, CopyOption ... var4);

    @Deprecated
    public DocumentModel copyProxyAsDocument(DocumentRef var1, DocumentRef var2, String var3, boolean var4);

    public List<DocumentModel> copyProxyAsDocument(List<DocumentRef> var1, DocumentRef var2, CopyOption ... var3);

    @Deprecated
    public List<DocumentModel> copyProxyAsDocument(List<DocumentRef> var1, DocumentRef var2, boolean var3);

    public DocumentModel move(DocumentRef var1, DocumentRef var2, String var3);

    public void move(List<DocumentRef> var1, DocumentRef var2);

    public ACP getACP(DocumentRef var1);

    public void setACP(DocumentRef var1, ACP var2, boolean var3);

    public void replaceACE(DocumentRef var1, String var2, ACE var3, ACE var4);

    public void updateReadACLs(Collection<String> var1);

    public boolean isNegativeAclAllowed();

    public DataModel getDataModel(DocumentRef var1, Schema var2);

    public DocumentModel getLastDocumentVersion(DocumentRef var1);

    public DocumentRef getLastDocumentVersionRef(DocumentRef var1);

    public DocumentModel getSourceDocument(DocumentRef var1);

    public List<DocumentRef> getVersionsRefs(DocumentRef var1);

    public List<DocumentModel> getVersions(DocumentRef var1);

    public List<VersionModel> getVersionsForDocument(DocumentRef var1);

    public DocumentModel getVersion(String var1, VersionModel var2);

    public String getVersionLabel(DocumentModel var1);

    public DocumentModel getDocumentWithVersion(DocumentRef var1, VersionModel var2);

    public DocumentModel restoreToVersion(DocumentRef var1, DocumentRef var2, boolean var3, boolean var4);

    public DocumentModel restoreToVersion(DocumentRef var1, DocumentRef var2);

    public DocumentRef getBaseVersion(DocumentRef var1);

    public void checkOut(DocumentRef var1);

    public DocumentRef checkIn(DocumentRef var1, VersioningOption var2, String var3);

    public boolean isCheckedOut(DocumentRef var1);

    public String getVersionSeriesId(DocumentRef var1);

    public DocumentModel getWorkingCopy(DocumentRef var1);

    public DocumentModel createProxy(DocumentRef var1, DocumentRef var2);

    public DocumentModelList query(String var1);

    public DocumentModelList query(String var1, int var2);

    public DocumentModelList query(String var1, Filter var2);

    public DocumentModelList query(String var1, Filter var2, int var3);

    public DocumentModelList query(String var1, Filter var2, long var3, long var5, boolean var7);

    public DocumentModelList query(String var1, Filter var2, long var3, long var5, long var7);

    public DocumentModelList query(String var1, String var2, Filter var3, long var4, long var6, boolean var8);

    public DocumentModelList query(String var1, String var2, Filter var3, long var4, long var6, long var8);

    public IterableQueryResult queryAndFetch(String var1, String var2, Object ... var3);

    public IterableQueryResult queryAndFetch(String var1, String var2, boolean var3, Object ... var4);

    public PartialList<Map<String, Serializable>> queryProjection(String var1, long var2, long var4);

    public PartialList<Map<String, Serializable>> queryProjection(String var1, long var2, long var4, boolean var6);

    public PartialList<Map<String, Serializable>> queryProjection(String var1, String var2, boolean var3, long var4, long var6, long var8, Object ... var10);

    public ScrollResult<String> scroll(String var1, int var2, int var3);

    public ScrollResult<String> scroll(String var1);

    public List<String> getAvailableSecurityPermissions();

    public void makeRecord(DocumentRef var1);

    public boolean isRecord(DocumentRef var1);

    public void setRetainUntil(DocumentRef var1, Calendar var2, String var3) throws PropertyException;

    public Calendar getRetainUntil(DocumentRef var1);

    public void setLegalHold(DocumentRef var1, boolean var2, String var3);

    public boolean hasLegalHold(DocumentRef var1);

    public boolean isUnderRetentionOrLegalHold(DocumentRef var1);

    @Deprecated
    public boolean isRetentionActive(DocumentRef var1);

    @Deprecated
    public void setRetentionActive(DocumentRef var1, boolean var2);

    public boolean isTrashed(DocumentRef var1);

    public String getCurrentLifeCycleState(DocumentRef var1);

    public String getLifeCyclePolicy(DocumentRef var1);

    public boolean followTransition(DocumentRef var1, String var2) throws LifeCycleException;

    public boolean followTransition(DocumentModel var1, String var2) throws LifeCycleException;

    public Collection<String> getAllowedStateTransitions(DocumentRef var1);

    public void reinitLifeCycleState(DocumentRef var1);

    public Object[] getDataModelsField(DocumentRef[] var1, String var2, String var3);

    public DocumentRef[] getParentDocumentRefs(DocumentRef var1);

    public Object[] getDataModelsFieldUp(DocumentRef var1, String var2, String var3);

    public Lock setLock(DocumentRef var1) throws LockException;

    public Lock getLockInfo(DocumentRef var1);

    public Lock removeLock(DocumentRef var1) throws LockException;

    public void applyDefaultPermissions(String var1);

    public DocumentModel publishDocument(DocumentModel var1, DocumentModel var2);

    public DocumentModel publishDocument(DocumentModel var1, DocumentModel var2, boolean var3);

    public DocumentModelList getProxies(DocumentRef var1, DocumentRef var2);

    public String getSuperParentType(DocumentModel var1);

    public DocumentModel getSuperSpace(DocumentModel var1);

    public String getRepositoryName();

    public <T extends Serializable> T getDocumentSystemProp(DocumentRef var1, String var2, Class<T> var3);

    public <T extends Serializable> void setDocumentSystemProp(DocumentRef var1, String var2, T var3);

    public void orderBefore(DocumentRef var1, String var2, String var3);

    public DocumentModel.DocumentModelRefresh refreshDocument(DocumentRef var1, int var2, String[] var3);

    public String[] getPermissionsToCheck(String var1);

    public <T extends DetachedAdapter> T adaptFirstMatchingDocumentWithFacet(DocumentRef var1, String var2, Class<T> var3);

    public Map<String, String> getBinaryFulltext(DocumentRef var1);

    public String getChangeToken(DocumentRef var1);

    public DocumentModel getOrCreateDocument(DocumentModel var1);

    public DocumentModel getOrCreateDocument(DocumentModel var1, Function<DocumentModel, DocumentModel> var2);

    public String replaceBlobDigest(DocumentRef var1, String var2, String var3, String var4);

    public static enum CopyOption {
        RESET_LIFE_CYCLE,
        RESET_CREATOR;


        public static boolean isResetLifeCycle(CopyOption ... options) {
            return Arrays.asList(options).contains((Object)RESET_LIFE_CYCLE);
        }

        public static boolean isResetCreator(CopyOption ... options) {
            return Arrays.asList(options).contains((Object)RESET_CREATOR);
        }
    }
}

