/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.blobholder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.BlobHolderAdapterService;
import org.nuxeo.ecm.core.api.blobholder.BlobHolderFactory;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentStringBlobHolder;
import org.nuxeo.ecm.core.api.externalblob.ExternalBlobAdapter;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class BlobHolderAdapterComponent
extends DefaultComponent
implements BlobHolderAdapterService {
    public static final String BLOBHOLDERFACTORY_EP = "BlobHolderFactory";
    public static final String EXTERNALBLOB_ADAPTER_EP = "ExternalBlobAdapter";
    protected Map<String, BlobHolderFactory> factoriesByName;
    protected Map<String, BlobHolderFactory> factoriesByType;
    protected Map<String, BlobHolderFactory> factoriesByFacets;
    protected Map<String, ExternalBlobAdapter> externalBlobAdapters;

    public void start(ComponentContext context) {
        this.factoriesByName = new HashMap<String, BlobHolderFactory>();
        this.factoriesByType = new HashMap<String, BlobHolderFactory>();
        this.factoriesByFacets = new HashMap<String, BlobHolderFactory>();
        this.getRegistryContributions(BLOBHOLDERFACTORY_EP).forEach(desc -> {
            String facet;
            String docType;
            String name = desc.getName();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                this.factoriesByName.put(name, desc.getFactory());
            }
            if ((docType = desc.getDocType()) != null) {
                this.factoriesByType.put(docType, desc.getFactory());
            }
            if ((facet = desc.getFacet()) != null) {
                this.factoriesByFacets.put(facet, desc.getFactory());
            }
        });
        this.externalBlobAdapters = new HashMap<String, ExternalBlobAdapter>();
        this.getRegistryContributions(EXTERNALBLOB_ADAPTER_EP).forEach(desc -> {
            ExternalBlobAdapter adapter = desc.getAdapter();
            adapter.setPrefix(desc.getPrefix());
            adapter.setProperties(desc.getProperties());
            this.externalBlobAdapters.put(desc.getPrefix(), adapter);
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.factoriesByName = null;
        this.factoriesByType = null;
        this.factoriesByFacets = null;
        this.externalBlobAdapters = null;
    }

    public Set<String> getFactoryNames() {
        return this.factoriesByType.keySet();
    }

    @Override
    public ExternalBlobAdapter getExternalBlobAdapterForPrefix(String prefix) {
        return this.externalBlobAdapters.get(prefix);
    }

    @Override
    public ExternalBlobAdapter getExternalBlobAdapterForUri(String uri) {
        if (uri != null && uri.contains(":")) {
            String prefix = uri.substring(0, uri.indexOf(":"));
            return this.getExternalBlobAdapterForPrefix(prefix);
        }
        return null;
    }

    @Override
    public Blob getExternalBlobForUri(String uri) throws PropertyException, IOException {
        ExternalBlobAdapter adapter = this.getExternalBlobAdapterForUri(uri);
        if (adapter == null) {
            throw new PropertyException(String.format("No external blob adapter found for uri '%s'", uri));
        }
        return adapter.getBlob(uri);
    }

    @Override
    public BlobHolder getBlobHolderAdapter(DocumentModel doc, String factoryName) {
        if (factoryName != null && this.factoriesByName.containsKey(factoryName)) {
            BlobHolderFactory factory = this.factoriesByName.get(factoryName);
            return factory.getBlobHolder(doc);
        }
        if (this.factoriesByType.containsKey(doc.getType())) {
            BlobHolderFactory factory = this.factoriesByType.get(doc.getType());
            return factory.getBlobHolder(doc);
        }
        for (Map.Entry<String, BlobHolderFactory> entry : this.factoriesByFacets.entrySet()) {
            if (!doc.hasFacet(entry.getKey())) continue;
            return entry.getValue().getBlobHolder(doc);
        }
        if (doc.hasSchema("file")) {
            return new DocumentBlobHolder(doc, "file:content");
        }
        if (doc.hasSchema("note")) {
            String mt = null;
            try {
                String note;
                mt = (String)((Object)doc.getPropertyValue("note:mime_type"));
                if (mt == null && (note = (String)((Object)doc.getPropertyValue("note:note"))) != null && !"".equals(note)) {
                    mt = "text/plain";
                }
            }
            catch (PropertyException propertyException) {
                // empty catch block
            }
            return new DocumentStringBlobHolder(doc, "note:note", mt);
        }
        return null;
    }

    @Override
    public BlobHolder getBlobHolderAdapter(DocumentModel doc) {
        return this.getBlobHolderAdapter(doc, null);
    }
}

