/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model;

import org.nuxeo.ecm.core.api.model.Delta;

public class DeltaLong
extends Delta {
    private static final long serialVersionUID = 1L;
    private final Long base;
    private final long delta;

    public DeltaLong(Long base, long delta) {
        this.base = base;
        this.delta = delta;
    }

    @Deprecated
    public DeltaLong(long base, long delta) {
        this.base = base;
        this.delta = delta;
    }

    public static DeltaLong valueOf(Number base, long delta) {
        if (base == null || base instanceof Long) {
            return new DeltaLong((Long)base, delta);
        }
        if (base instanceof DeltaLong) {
            DeltaLong dl = (DeltaLong)base;
            if (delta == 0L) {
                return dl;
            }
            return new DeltaLong(dl.base, dl.delta + delta);
        }
        throw new IllegalArgumentException(base.getClass().getName());
    }

    @Deprecated
    public static DeltaLong deltaOrLong(Number base, long delta) {
        return DeltaLong.valueOf(base, delta);
    }

    @Override
    public Delta add(Delta other) {
        if (!(other instanceof DeltaLong)) {
            throw new IllegalArgumentException("Cannot add " + this.getClass().getSimpleName() + " and " + other.getClass().getSimpleName());
        }
        return new DeltaLong(this.base, this.delta + ((DeltaLong)other).delta);
    }

    @Override
    public Number add(Number other) {
        if (!(other instanceof Long)) {
            throw new IllegalArgumentException("Cannot add " + this.getClass().getSimpleName() + " and " + other.getClass().getSimpleName());
        }
        return (Long)other + this.delta;
    }

    @Override
    public Long getBase() {
        return this.base;
    }

    public long getDelta() {
        return this.delta;
    }

    @Override
    public Long getDeltaValue() {
        return this.delta;
    }

    @Override
    public Long getFullValue() {
        return this.longValue();
    }

    @Override
    public long longValue() {
        return this.base == null ? this.delta : this.base + this.delta;
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    public String toString() {
        return Long.toString(this.longValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DeltaLong) {
            DeltaLong dl = (DeltaLong)obj;
            if (this.delta != dl.delta) {
                return false;
            }
            return this.base == null ? dl.base == null : this.base.equals(dl.base);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 31;
        if (this.base != null) {
            long b = this.base;
            result += (int)(b ^ b >>> 32);
        }
        return 31 * result + (int)(this.delta ^ this.delta >>> 32);
    }
}

