/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.BlobProviderDescriptor;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.binary.BinaryBlobProvider;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class BlobManagerComponent
extends DefaultComponent
implements BlobManager {
    protected static final String XP = "configuration";
    public static final String DEFAULT_ID = "default";
    public static final String TRANSIENT_ID_PREFIX = "transient";
    public static final String BLOB_KEY_REPLACEMENT_KV = "blobKeyReplacement";
    protected static final Duration BLOB_KEY_REPLACEMENT_TTL = Duration.ofHours(1L);
    protected boolean blobProvidersInitialized;
    protected Map<String, BlobProvider> blobProviders = new ConcurrentHashMap<String, BlobProvider>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ComponentContext context) {
        BlobManagerComponent blobManagerComponent = this;
        synchronized (blobManagerComponent) {
            this.blobProvidersInitialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(ComponentContext context) throws InterruptedException {
        for (BlobProvider blobProvider : this.blobProviders.values()) {
            blobProvider.close();
        }
        this.blobProviders.clear();
        BlobManagerComponent blobManagerComponent = this;
        synchronized (blobManagerComponent) {
            this.blobProvidersInitialized = false;
        }
    }

    public void registerBlobProvider(BlobProviderDescriptor descr) {
        this.closeOldBlobProvider(descr.name);
        this.blobProviders.put(descr.name, this.createBlobProvider(descr));
    }

    public void unregisterBlobProvider(BlobProviderDescriptor descr) {
        this.closeOldBlobProvider(descr.name);
        this.blobProviders.remove(descr.name);
    }

    protected synchronized void closeOldBlobProvider(String id) {
        BlobProvider blobProvider = this.blobProviders.remove(id);
        if (blobProvider != null) {
            blobProvider.close();
        }
    }

    protected BlobProvider createBlobProvider(BlobProviderDescriptor descr) {
        BlobProvider blobProvider;
        Map<String, String> properties;
        String providerId;
        block7: {
            providerId = descr.name;
            Class<?> klass = descr.klass;
            properties = descr.properties;
            try {
                if (BlobProvider.class.isAssignableFrom(klass)) {
                    Class<?> blobProviderClass = klass;
                    blobProvider = (BlobProvider)blobProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    break block7;
                }
                if (BinaryManager.class.isAssignableFrom(klass)) {
                    Class<?> binaryManagerClass = klass;
                    BinaryManager binaryManager = (BinaryManager)binaryManagerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    blobProvider = new BinaryBlobProvider(binaryManager);
                    break block7;
                }
                throw new RuntimeException("Unknown class for blob provider: " + klass);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        if (providerId.startsWith(TRANSIENT_ID_PREFIX)) {
            descr.properties.put(TRANSIENT_ID_PREFIX, "true");
        }
        try {
            blobProvider.initialize(providerId, properties);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return blobProvider;
    }

    @Override
    public synchronized BlobProvider getBlobProvider(String providerId) {
        BlobProvider blobProvider = this.blobProviders.get(providerId);
        if (blobProvider == null) {
            this.getRegistryContribution(XP, providerId).ifPresent(descr -> this.blobProviders.put(providerId, this.createBlobProvider((BlobProviderDescriptor)descr)));
            return this.blobProviders.get(providerId);
        }
        return blobProvider;
    }

    @Override
    public synchronized BlobProvider getBlobProviderWithNamespace(String providerId, String defaultId) {
        BlobProvider blobProvider = this.getBlobProvider(providerId);
        if (blobProvider != null) {
            return blobProvider;
        }
        BlobProviderDescriptor defaultDescr = (BlobProviderDescriptor)this.getRegistryContribution(XP, defaultId).orElseThrow(() -> new NuxeoException("Missing configuration for blob provider: " + defaultId));
        BlobProviderDescriptor descr = new BlobProviderDescriptor(defaultDescr);
        descr.name = providerId;
        descr.properties.put("namespace", providerId);
        this.registerBlobProvider(descr);
        return this.getBlobProvider(providerId);
    }

    @Override
    public BlobProvider getBlobProvider(Blob blob) {
        if (!(blob instanceof ManagedBlob)) {
            return null;
        }
        ManagedBlob managedBlob = (ManagedBlob)blob;
        return this.getBlobProvider(managedBlob.getProviderId());
    }

    @Override
    @Deprecated
    public InputStream getStream(Blob blob) throws IOException {
        return blob instanceof ManagedBlob ? blob.getStream() : null;
    }

    @Override
    @Deprecated
    public File getFile(Blob blob) {
        return blob instanceof ManagedBlob ? blob.getFile() : null;
    }

    @Override
    public InputStream getThumbnail(Blob blob) throws IOException {
        BlobProvider blobProvider = this.getBlobProvider(blob);
        if (blobProvider == null) {
            return null;
        }
        return blobProvider.getThumbnail((ManagedBlob)blob);
    }

    @Override
    public URI getURI(Blob blob, BlobManager.UsageHint hint, HttpServletRequest servletRequest) throws IOException {
        BlobProvider blobProvider = this.getBlobProvider(blob);
        if (blobProvider == null) {
            return null;
        }
        return blobProvider.getURI((ManagedBlob)blob, hint, servletRequest);
    }

    @Override
    public Map<String, URI> getAvailableConversions(Blob blob, BlobManager.UsageHint hint) throws IOException {
        BlobProvider blobProvider = this.getBlobProvider(blob);
        if (blobProvider == null) {
            return Collections.emptyMap();
        }
        return blobProvider.getAvailableConversions((ManagedBlob)blob, hint);
    }

    @Override
    public synchronized Map<String, BlobProvider> getBlobProviders() {
        if (!this.blobProvidersInitialized) {
            this.getRegistryContributions(XP).stream().filter(desc -> !this.blobProviders.containsKey(desc.name)).forEach(this::registerBlobProvider);
            this.blobProvidersInitialized = true;
        }
        return Collections.unmodifiableMap(this.blobProviders);
    }

    protected KeyValueStore getBlobKeyReplacementKeyValuestore() {
        KeyValueService kvService = (KeyValueService)Framework.getService(KeyValueService.class);
        return kvService == null ? null : kvService.getKeyValueStore(BLOB_KEY_REPLACEMENT_KV);
    }

    @Override
    public void setBlobKeyReplacement(String blobProviderId, String key, String newKey) {
        KeyValueStore kvStore = this.getBlobKeyReplacementKeyValuestore();
        if (kvStore == null) {
            return;
        }
        kvStore.put(blobProviderId + ":" + key, newKey, BLOB_KEY_REPLACEMENT_TTL.getSeconds());
    }

    @Override
    public String getBlobKeyReplacement(String blobProviderId, String key) {
        KeyValueStore kvStore = this.getBlobKeyReplacementKeyValuestore();
        if (kvStore == null) {
            return key;
        }
        String newKey = kvStore.getString(blobProviderId + ":" + key);
        return newKey == null ? key : newKey;
    }
}

