/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobContext;
import org.nuxeo.ecm.core.blob.BlobWriteContext;
import org.nuxeo.ecm.core.blob.KeyStrategy;

public class KeyStrategyDigest
implements KeyStrategy {
    public final String digestAlgorithm;
    public final Pattern digestPattern;

    public KeyStrategyDigest(String digestAlgorithm) {
        Objects.requireNonNull(digestAlgorithm);
        this.digestAlgorithm = digestAlgorithm;
        this.digestPattern = KeyStrategyDigest.getDigestPattern(digestAlgorithm);
    }

    @Override
    public boolean useDeDuplication() {
        return true;
    }

    @Override
    public String getDigestFromKey(String key) {
        return this.isValidDigest(key) ? key : null;
    }

    public boolean isValidDigest(String key) {
        return this.digestPattern.matcher(key).matches();
    }

    protected static Pattern getDigestPattern(String digestAlgorithm) {
        int len = new DigestUtils(digestAlgorithm).digestAsHex(new byte[0]).length();
        return Pattern.compile("[0-9a-f]{" + len + "}");
    }

    @Override
    public BlobWriteContext getBlobWriteContext(BlobContext blobContext) {
        MutableObject keyHolder = new MutableObject();
        WriteObserverDigest writeObserver = new WriteObserverDigest(this.digestAlgorithm, arg_0 -> ((MutableObject)keyHolder).setValue(arg_0));
        Supplier<String> keyComputer = () -> ((MutableObject)keyHolder).getValue();
        return new BlobWriteContext(blobContext, writeObserver, keyComputer, this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyStrategyDigest)) {
            return false;
        }
        KeyStrategyDigest other = (KeyStrategyDigest)obj;
        return this.digestAlgorithm.equals(other.digestAlgorithm);
    }

    public int hashCode() {
        return this.digestAlgorithm.hashCode();
    }

    public static class WriteObserverDigest
    implements KeyStrategy.WriteObserver {
        protected final MessageDigest messageDigest;
        protected final Consumer<String> keyConsumer;
        protected DigestOutputStream dos;

        public WriteObserverDigest(String digestAlgorithm, Consumer<String> keyConsumer) {
            try {
                this.messageDigest = MessageDigest.getInstance(digestAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new NuxeoException(e);
            }
            this.keyConsumer = keyConsumer;
        }

        @Override
        public OutputStream wrap(OutputStream out) {
            this.dos = new DigestOutputStream(out, this.messageDigest);
            return this.dos;
        }

        @Override
        public void done() {
            String key = Hex.encodeHexString((byte[])this.dos.getMessageDigest().digest());
            this.keyConsumer.accept(key);
        }
    }
}

